/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.launchconfig;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/**
 * 
 * @author amiguel
 *
 * A TraceListener implementation that can listen to a running engine and 
 * print all the info and debug information to a standard MessageConsole
 */
public class ConsoleEngineListener implements BPELEngineListener {
		
	boolean require_save = false;
	
	boolean die = false;
	
	Object console_LOCK = new Object();
	
	//TODO could potentially use org.eclipse.debug.ui.DebugUITools
	//to create a console that I could then have hyperlinks in.
	
	MessageConsole console;
	public MessageConsoleStream err_cstream;
	public MessageConsoleStream engine_cstream;
	public MessageConsoleStream ok_cstream;

	public ConsoleEngineListener(String name) {
		console = new MessageConsole(name,null);
		err_cstream = console.newMessageStream();
		engine_cstream = console.newMessageStream();
		ok_cstream = console.newMessageStream();
		
		Display.getDefault().syncExec(new Setup());
	}

	class Setup implements Runnable {
		public void run() {
			ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
			ConsolePlugin.getDefault().getConsoleManager().showConsoleView(console);
			
			err_cstream.setColor(Display.getDefault().getSystemColor(SWT.COLOR_DARK_RED));
			engine_cstream.setColor(Display.getDefault().getSystemColor(SWT.COLOR_DARK_BLUE));
			ok_cstream.setColor(Display.getDefault().getSystemColor(SWT.COLOR_DARK_GREEN));
		}
	}

	public void printInfo(String s) {
		ok_cstream.println(s);
	}
	public void printDebug(String s) {
		err_cstream.println(s);
	}
	public void printEngineInfo(String s) {
		engine_cstream.println(s);
	}
	public void printEngineDebug(String s) {
		err_cstream.println(s);
	}
	
}