/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 * 
 * Part of the generic runtime engine API, used to help implement BPEL partner links.
 */
public class BPELPartnerLink {
	public WSEndpointReference myRole;
	public WSEndpointReference partnerRole;

//	public void t() throws Exception {
//		WSEndpointReference.fromXML(WSEndpointReference.toXML(partnerRole));
//	}
	
	public static BPELPartnerLink createPartnerLink(String name) throws Exception {
		Runner r = (Runner)Thread.currentThread();
		
		Message m = new Message();
		m.append((String)null);
		m.append((String)null);
		
		SharedVariable var = r.newVariable("BPELPartnerLink.variables."+name, SharedVariable.MESSAGE, true);
		var.setValue(m);
		var.varStore();
		
		BPELPartnerLink link = new BPELPartnerLink();
		link.myRole = null;
		link.partnerRole = null;
		return link;
	}
	
	public static void setPartnerLink(String name,BPELPartnerLink link) throws Exception {
		Runner r = (Runner)Thread.currentThread();
		
		SharedVariable var = r.getVariable("BPELPartnerLink.variables."+name);

		Message m = new Message();
		
		if (link.myRole == null) {
			m.append((String)null);
		} else {
			m.append(link.myRole.toString());
		}
		if (link.partnerRole == null) {
			m.append((String)null);
		} else {
			m.append(link.partnerRole.toString());
		}	
		
		var.setValue(m);
		var.varStore();

//		HashMap map = r.getEngineLocalStorageMap("BPELPartnerLinks");
//		map.put(name,link);
	}
	
	public static BPELPartnerLink getPartnerLink(String name) throws Exception {
		Runner r = (Runner)Thread.currentThread();

		SharedVariable var = r.getVariable("BPELPartnerLink.variables."+name);
		var.varFetch();
		
		Message m = var.getValueMessage();
		
		String myrole = (String)m.get(0);
		String partnerrole = (String)m.get(1);
		
		BPELPartnerLink link = new BPELPartnerLink();
		
		if (myrole == null) {
			link.myRole = null;
		} else {
			link.myRole = WSEndpointReference.fromXML(myrole);
		}
		if (partnerrole == null) {
			link.partnerRole = null;
		} else {
			link.partnerRole = WSEndpointReference.fromXML(partnerrole);
		}
		
		return link;
		
//		HashMap map = r.getEngineLocalStorageMap("BPELPartnerLinks");
//		return (BPELPartnerLink)map.get(name);
	}
}