/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures;

import java.util.ArrayList;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class VerticalLabel
extends WrapLabel {
    private Image labelImage = null;
    private Color parentBackgroundColor = null;
    private double cacheScale = -1.0;
    private boolean isVertical = true;
    private static boolean ERROR_WHEN_PAINTING = false;

    public VerticalLabel() {
        this.setOpaque(true);
    }

    public VerticalLabel(boolean isVertical) {
        this();
        this.setVertical(isVertical);
    }

    public void invalidate() {
        this.disposeImage();
        super.invalidate();
    }

    public void erase() {
        this.disposeImage();
        super.erase();
    }

    public void removeNotify() {
        super.removeNotify();
        this.disposeImage();
    }

    private void disposeImage() {
        if (this.labelImage != null) {
            if (!this.labelImage.isDisposed()) {
                this.labelImage.dispose();
            }
            this.labelImage = null;
        }
    }

    public void paintFigure(Graphics graphics) {
        if (!this.isVertical || ERROR_WHEN_PAINTING) {
            super.paintFigure(graphics);
            return;
        }
        if (this.labelImage != null && this.cacheScale != graphics.getAbsoluteScale()) {
            this.disposeImage();
        }
        if (this.labelImage == null || !graphics.getBackgroundColor().equals((Object)this.parentBackgroundColor)) {
            String theText = super.getText();
            if (theText == null || theText.trim().length() == 0) {
                theText = " ";
            }
            this.parentBackgroundColor = graphics.getBackgroundColor();
            try {
                this.labelImage = this.createRotatedImageOfString(graphics, theText, super.getFont(), this.getForegroundColor(), graphics.getBackgroundColor(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.disposeImage();
                ERROR_WHEN_PAINTING = true;
                super.paintFigure(graphics);
                return;
            }
            this.cacheScale = graphics.getAbsoluteScale();
        }
        double scale = graphics.getAbsoluteScale();
        graphics.pushState();
        graphics.scale(1.0 / scale);
        Point topLeft = this.getBounds().getTopLeft();
        topLeft = new Point((double)topLeft.x * scale, (double)topLeft.y * scale);
        graphics.drawImage(this.labelImage, topLeft);
        graphics.popState();
    }

    public Image createRotatedImageOfString(Graphics g, String string, Font font, Color foreground, Color background, boolean useGCTransform) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ArrayList<FontData> fontDatas = new ArrayList<FontData>();
        FontData[] fontDataArray = font.getFontData();
        int n = 0;
        int n2 = fontDataArray.length;
        while (n < n2) {
            FontData data = fontDataArray[n];
            FontData data2 = new FontData(data.getName(), (int)((double)data.height * g.getAbsoluteScale()), data.getStyle());
            fontDatas.add(data2);
            ++n;
        }
        Font zoomedFont = new Font((Device)display, fontDatas.toArray(new FontData[0]));
        Dimension strDim = FigureUtilities.getTextExtents((String)string, (Font)zoomedFont);
        if (strDim.width == 0 || strDim.height == 0) {
            strDim = FigureUtilities.getTextExtents((String)string, (Font)font);
        }
        Image srcImage = useGCTransform ? new Image((Device)display, strDim.height, strDim.width) : new Image((Device)display, strDim.width, strDim.height);
        GC gc = new GC((Drawable)srcImage);
        if (useGCTransform) {
            Transform transform = new Transform((Device)display);
            transform.rotate(-90.0f);
            gc.setTransform(transform);
        }
        gc.setFont(zoomedFont);
        gc.setForeground(foreground);
        gc.setBackground(background);
        gc.fillRectangle(gc.getClipping());
        gc.drawText(string, gc.getClipping().x, gc.getClipping().y);
        gc.dispose();
        if (useGCTransform) {
            srcImage.dispose();
            zoomedFont.dispose();
            return srcImage;
        }
        this.disposeImage();
        Image rotated = ImageUtilities.createRotatedImage((Image)srcImage);
        srcImage.dispose();
        zoomedFont.dispose();
        return rotated;
    }

    public Rectangle getTextBounds() {
        Rectangle rect = super.getTextBounds();
        if (!this.isVertical) {
            return rect;
        }
        Rectangle bounds = new Rectangle(this.getParent().getBounds().x, rect.y, rect.height, rect.width);
        return bounds;
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        if (this.isVertical) {
            return new Dimension(Math.max(txtSize.height, 20), txtSize.width + 4);
        }
        txtSize.height += 4;
        return super.calculateLabelSize(txtSize);
    }

    public void setVertical(boolean isVertical) {
        if (this.isVertical != isVertical) {
            this.isVertical = isVertical;
            this.disposeImage();
            this.revalidate();
        }
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        this.disposeImage();
        this.revalidate();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.disposeImage();
        this.revalidate();
    }
}

