/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Tool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.handles.ConnectionHandleEx;
import org.eclipse.stp.bpmn.handles.ConnectionHandleForAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandleEditPolicyEx
extends DiagramAssistantEditPolicy {
    private OwnerMovedListener ownerMovedListener = new OwnerMovedListener();
    private List handles = null;

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof ConnectionHandle;
    }

    protected List<ConnectionHandle> getHandleFigures(int borderSide) {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
        ModelingAssistantService service = ModelingAssistantService.getInstance();
        List srcEltTypes = service.getRelTypesOnSource((IAdaptable)this.getHost());
        List tgtEltTypes = service.getRelTypesOnTarget((IAdaptable)this.getHost());
        switch (borderSide) {
            case 8: {
                if (!tgtEltTypes.contains(BpmnElementTypes.SequenceEdge_3001)) break;
                list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, this.buildTooltip(ConnectionHandle.HandleDirection.INCOMING)));
                break;
            }
            case 16: {
                if (!srcEltTypes.contains(BpmnElementTypes.SequenceEdge_3001)) break;
                list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, this.buildTooltip(ConnectionHandle.HandleDirection.OUTGOING)));
                break;
            }
            case 1: 
            case 4: {
                if (tgtEltTypes.contains(BpmnElementTypes.MessagingEdge_3002)) {
                    list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, this.buildTooltip(ConnectionHandle.HandleDirection.INCOMING)));
                }
                if (!srcEltTypes.contains(BpmnElementTypes.MessagingEdge_3002)) break;
                list.add(new ConnectionHandleEx((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, this.buildTooltip(ConnectionHandle.HandleDirection.OUTGOING)));
            }
        }
        this.setAssociationHandleFigures(borderSide, list, srcEltTypes, tgtEltTypes);
        return list;
    }

    protected void setAssociationHandleFigures(int borderSide, List<ConnectionHandle> list, List<IElementType> srcEltTypes, List<IElementType> tgtEltTypes) {
        if (srcEltTypes.contains(BpmnElementTypes.Association_3003)) {
            list.add(new ConnectionHandleForAssociation((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, "Association"));
        } else if (tgtEltTypes.contains(BpmnElementTypes.Association_3003)) {
            list.add(new ConnectionHandleForAssociation((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.INCOMING, "Association"));
        }
    }

    protected String buildTooltip(ConnectionHandle.HandleDirection direction) {
        return DiagramUIMessages.ConnectionHandle_ToolTip_ShowRelatedElementsAndCreateRelationship;
    }

    public void activate() {
        super.activate();
        ((IGraphicalEditPart)this.getHost()).getFigure().addFigureListener((FigureListener)this.ownerMovedListener);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeFigureListener((FigureListener)this.ownerMovedListener);
        super.deactivate();
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (referencePoint == null) {
            referencePoint = this.getHostFigure().getBounds().getRight();
        }
        ConnectionHandleLocator locator = this.getConnectionHandleLocator(referencePoint);
        this.getHost();
        this.handles = this.getHandleFigures(locator.getBorderSide());
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (ConnectionHandle handle : this.handles) {
            handle.setLocator((Locator)locator);
            locator.addHandle(handle);
            handle.addMouseMotionListener((MouseMotionListener)this);
            layer.add((IFigure)handle);
            this.getHost().getViewer().getVisualPartMap().put(handle, this.getHost());
        }
        if (!this.shouldAvoidHidingDiagramAssistant()) {
            this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
        }
    }

    protected boolean isPreferenceOn() {
        String prefName = this.getThePreferenceName();
        if (prefName == null) {
            return true;
        }
        IPreferenceStore preferenceStore = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
        return preferenceStore.getBoolean(prefName);
    }

    protected String getThePreferenceName() {
        return "Global.showConnectionHandles";
    }

    protected void hideDiagramAssistant() {
        if (this.handles == null) {
            return;
        }
        IFigure layer = this.getLayer("Handle Layer");
        for (IFigure handle : this.handles) {
            handle.removeMouseMotionListener((MouseMotionListener)this);
            layer.remove(handle);
            this.getHost().getViewer().getVisualPartMap().remove(handle);
        }
        this.handles = null;
        this.getHost();
    }

    private boolean isSelectionToolActive() {
        Tool theTool;
        return this.getHost().getParent() != null && (theTool = this.getHost().getViewer().getEditDomain().getActiveTool()) != null && theTool instanceof SelectionTool;
    }

    protected boolean shouldShowDiagramAssistant() {
        if (this.getAppearanceDelay() < 0) {
            return false;
        }
        if (!super.shouldShowDiagramAssistant()) {
            return false;
        }
        return this.handles == null && this.isSelectionToolActive();
    }

    protected ConnectionHandleLocator getConnectionHandleLocator(Point referencePoint) {
        if (this.getHost() instanceof ActivityEditPart) {
            Activity activity = (Activity)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
            Rectangle bounds = ((IGraphicalEditPart)this.getHost()).getFigure().getBounds().getCopy();
            if (ActivityType.VALUES_EVENTS.contains(activity.getActivityType()) || ActivityType.VALUES_EVENTS.contains(activity.getActivityType())) {
                bounds = ((IFigure)((IFigure)((IGraphicalEditPart)this.getHost()).getFigure().getChildren().get(0)).getChildren().get(0)).getBounds().getCopy();
            }
            if (bounds.width != 0 && bounds.height != 0) {
                boolean overFirstDiag = this.isOverALine(bounds.getBottomRight(), bounds.getTopLeft(), referencePoint);
                boolean overSecondDiag = this.isOverALine(bounds.getTopRight(), bounds.getBottomLeft(), referencePoint);
                referencePoint = overFirstDiag ? (overSecondDiag ? bounds.getTop().getCopy() : bounds.getRight().getCopy()) : (overSecondDiag ? bounds.getLeft().getCopy() : bounds.getBottom().getCopy());
            }
        }
        return new ConnectionHandleLocator(this.getHostFigure(), referencePoint);
    }

    private boolean isOverALine(Point firstPoint, Point secondPoint, Point toEvaluate) {
        int yb = secondPoint.y;
        int ya = firstPoint.y;
        int xb = secondPoint.x;
        int xa = firstPoint.x;
        double coeff = (double)(yb - ya) / (double)(xb - xa);
        double constant = (xb * ya - yb * xa) / (xb - xa);
        return (double)toEvaluate.y < coeff * (double)toEvaluate.x + constant;
    }

    protected boolean isDiagramAssistantShowing() {
        return this.handles != null;
    }

    protected int getAppearanceDelay() {
        IPreferenceStore preferenceStore = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
        int delay = preferenceStore.getInt("bpmn.connection.assistant.appearance.delay");
        return delay > -1 ? delay : 60;
    }

    private class OwnerMovedListener
    implements FigureListener {
        private OwnerMovedListener() {
        }

        public void figureMoved(IFigure source) {
            ConnectionHandleEditPolicyEx.this.hideDiagramAssistant();
        }
    }
}

