package client;

import org.apache.tuscany.container.java.module.EventContext;
import org.apache.tuscany.container.java.module.TuscanyModuleComponentContext;
import org.apache.tuscany.container.java.module.impl.DefaultScopeStrategy;
import org.apache.tuscany.container.java.module.impl.SDOConfigurer;
import org.apache.tuscany.container.java.module.impl.TuscanyModuleComponentContextImpl;
import org.osoa.sca.SCA;

import services.profile.LoginService;

public class TestClient extends SCA {
	
	public void start() { }

	public void stop() { }

	public static void main(String[] args) throws Exception {

		SDOConfigurer configurer = new SDOConfigurer();
		TuscanyModuleComponentContext moduleComponent =
			new TuscanyModuleComponentContextImpl(
					1, "bigbank.accountmodule.testclient", "uri",
					new DefaultScopeStrategy(), configurer);

		setModuleContext(moduleComponent);
		moduleComponent.start();
		moduleComponent.fireEvent(EventContext.MODULE_START, null);
		moduleComponent.fireEvent(EventContext.REQUEST_START, null);
		Object key = new Object();
		moduleComponent.fireEvent(EventContext.SESSION_NOTIFY, key);
		LoginService loginService = (LoginService)
			moduleComponent.locateService("LoginServiceComponent");

		if (loginService.login("test", "password") == LoginService.SUCCESS)
			System.out.println("Success");
		else
			System.out.println("Failure");
	}
}
