/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.resources.ComponentTypeScribblerDomain;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.SCACoreRoot;

public class ComponentTypeArtifactEdit {
    private IEditModelScribbler scribbler;
    private ComponentTypeScribblerDomain domain;

    public ComponentTypeArtifactEdit(ComponentTypeScribblerDomain aDomain, boolean toMakeReadOnly) throws EditModelException {
        Assert.isNotNull((Object)((Object)aDomain));
        this.scribbler = toMakeReadOnly ? aDomain.createScribblerForRead() : aDomain.createScribblerForWrite();
        this.domain = aDomain;
    }

    public ComponentType getComponentType() {
        Resource resource = this.scribbler.getResource((IResourceDescriptor)this.domain.getComponentTypeDescriptor());
        Assert.isTrue((boolean)(resource.getContents().get(0) instanceof SCACoreRoot));
        SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
        return root.getComponentType();
    }

    public void save(boolean force, IProgressMonitor monitor) throws EditModelException {
        this.scribbler.save(force, monitor);
    }

    public void discard(IProgressMonitor monitor) throws EditModelException {
        this.scribbler.discard(monitor);
    }

    public void close(IProgressMonitor monitor) throws EditModelException {
        this.scribbler.close(monitor);
    }
}

