/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * An ITechnologyFlavorLifecycle provides an opportunity to manage other
 * technologies that are related to a set of resources, but may not be EMF
 * based.
 * 
 * <p>
 * The ITechnologyFlavorLifecycles are integrated into the IEditModel framework
 * through IEditingDomains. As lifecycle operations are invoked on the
 * IEditModelScribbler, those methods will be delegated into the Lifecycle at
 * the appropriate time.
 * </p>
 */
public interface ITechnologyFlavorLifecycle {

   int SAVE    = 100;

   int DISCARD = 101;

   /**
    * Returns the identifier for this manager.
    * 
    * @return
    */
   String getId();

   ITechnologyFlavor createFlavor(IAdaptable adaptable);

   /**
    * Persist all changes from the models managed by this
    * ITechnologyFlavorManager
    * 
    * <p>
    * This method will also persist any requests to delete resource (from
    * deleteResource()).
    * </p>
    * 
    * @param force
    *           Specifies whether the save should be forced
    * @param monitor
    * @throws EditModelException
    */
   void save(boolean force, IProgressMonitor monitor);

   /**
    * Revert all changes made to the form found on disk.
    * 
    * @param monitor
    */
   void revert(IProgressMonitor monitor);

   /**
    * Discard any changes made to this point and release any model elements held
    * onto by the manager.
    * 
    * @param monitor
    */
   void discard(IProgressMonitor monitor);

   /**
    * Close the model elements held onto by the manager. Use the option supplied
    * to determine if a save or discard should execute for any changes that have
    * been made but not saved.
    * 
    * @param option
    * @param monitor
    */
   void close(int option, IProgressMonitor monitor);
}
