/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.saf.ui;

import java.text.MessageFormat;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/**
 * The main plug-in class to be used on the desktop.
 */
public class Activator extends Plugin {
	
	private final static String PLUGIN_ID = "org.eclipse.stp.core.saf.ui";  //$NON-NLS-1$

	//The shared instance.
	private static Activator plugin;
	
	/**
	 * The constructor.
	 */
	public Activator() {
		plugin = this;
  	}

	/**
	 * This method is called when the plug-in is activated.
	 * 
	 * @param context
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped.
	 * 
	 * @param context
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	/**
	 * 
	 * @param e
	 * @param msg
	 */
	public static void log(Throwable e, String msg) {
		if (msg == null)
			msg = e.getMessage();
		if (msg == null)
			msg = ""; //$NON-NLS-1$
	
		IStatus status = new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK, msg, e);
		getDefault().getLog().log(status);
	}
	
	/**
	 * @param msgTemplate
	 * @param values
	 * @return message
	 */
	public static String internalReportConfigurationError(String msgTemplate, Object[] values) {
		// Report an error from the internal plugin.properties file.
		String error = MessageFormat.format(msgTemplate, values);
		Activator.log(new Exception(), error);
		return error;
	}

}
