/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;

/**
 * Manages a set of EAttributes for a single logical EStructuralFeature element.
 * For each attribute, the "value" of that attribute is stored, along with a
 * boolean indicating if it's a unique attribute for the containing feature
 * (e.g. Service_Name() is a unique key for Service).
 * 
 * @since 1.0
 * 
 */
public class AttributeSet {

   private static final EAttribute[] NO_ATTRIBUTES       = new EAttribute[0];

   private Map                       attributeValues     = new HashMap();

   private Map                       attributeUniqueness = new HashMap();

   public Iterator iterator() {
      return attributeValues.keySet().iterator();
   }

   public EAttribute[] uniqueKeys() {
      List uniqueKeys = new ArrayList();
      EAttribute attribute = null;
      for (Iterator attrItr = attributeUniqueness.keySet().iterator(); attrItr
            .hasNext();) {
         attribute = (EAttribute) attrItr.next();
         if (((Boolean) attributeUniqueness.get(attribute)).booleanValue())
            uniqueKeys.add(attribute);

      }
      if (uniqueKeys.isEmpty())
         return NO_ATTRIBUTES;
      else
         return (EAttribute[]) uniqueKeys.toArray(new EAttribute[uniqueKeys
               .size()]);
   }

   public void add(EAttribute attribute, Object value, boolean isUniqueKey) {
      attributeValues.put(attribute, value);
      attributeUniqueness.put(attribute, isUniqueKey ? Boolean.TRUE
            : Boolean.FALSE);
   }

   public boolean isUniqueKey(EAttribute attribute) {
      Boolean b = (Boolean) attributeUniqueness.get(attribute);
      return b != null ? b.booleanValue() : false;
   }

   public Object getValue(EAttribute attribute) {
      return attributeValues.get(attribute);
   }

   public void reset() {
      attributeValues.clear();
      attributeUniqueness.clear();
   }

}
