/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

/**
 * This interface represents a service element in the SCA tooling model. A
 * service may be an {@link org.eclipse.stp.core.sca.ExternalService} or a
 * {@link org.eclipse.stp.core.sca.Service} on a
 * {@link org.eclipse.stp.core.sca.ComponentType}.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * 
 * @since 1.0
 */
public interface AbstractService extends SCAObject {

   /**
    * Return the Interface assigned to this service.
    * 
    * @return Interface
    */
   Interface getInterface();

   /**
    * @param reference
    *           The AbstractReference to test for compatibility.
    * @return boolean True if and only if the Interface of the given reference
    *         is compatible with this service.
    */
   boolean matches(AbstractReference reference);
}
