/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.common.logging.LoggingProxy;

public class ScFolderGenerationUtils {
    public static final LoggingProxy LOG = LoggingProxy.getlogger(ScFolderGenerationUtils.class);

    public static IFolder getSrcGenFolder(IProject baseProject) {
        return baseProject.getFolder("src-gen");
    }

    public static IFolder getWsdlGenFolder(IProject baseProject) {
        return baseProject.getFolder("wsdl");
    }

    public static IFolder getDeployGenFolder(IProject baseProject) {
        return baseProject.getFolder("WebContent");
    }

    public static boolean makeSrcFolder(IFolder newSrcFolder) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)newSrcFolder.getProject());
            IClasspathEntry newClasspath = JavaCore.newSourceEntry((IPath)newSrcFolder.getFullPath());
            IClasspathEntry[] oldClasspathEntries = javaProject.getRawClasspath();
            boolean isFolderInClassPathAlready = false;
            int i = 0;
            while (i < oldClasspathEntries.length && !isFolderInClassPathAlready) {
                if (oldClasspathEntries[i].getPath().equals((Object)newSrcFolder.getFullPath())) {
                    isFolderInClassPathAlready = true;
                    LOG.info((Object)("the foldser [" + newSrcFolder.getFullPath() + "] is alreday in the project classpath"));
                }
                ++i;
            }
            if (!isFolderInClassPathAlready) {
                IClasspathEntry[] newClasspathEntries = new IClasspathEntry[oldClasspathEntries.length + 1];
                int i2 = 0;
                while (i2 < oldClasspathEntries.length) {
                    newClasspathEntries[i2] = oldClasspathEntries[i2];
                    ++i2;
                }
                newClasspathEntries[oldClasspathEntries.length] = newClasspath;
                javaProject.setRawClasspath(newClasspathEntries, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            LOG.error((Object)"failed to add a new source foder to project", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean createFolder(IContainer aFolder) {
        block4: {
            try {
                aFolder.getProject().refreshLocal(2, null);
                if (aFolder.isAccessible()) break block4;
                ScFolderGenerationUtils.createFolder(aFolder.getParent());
                if (aFolder instanceof IProject) {
                    IProject project = (IProject)aFolder;
                    project.create(null);
                    project.open(null);
                    LOG.debug((Object)("project created: " + project.getName()));
                    break block4;
                }
                if (aFolder instanceof IFolder) {
                    LOG.debug((Object)("folder to create: " + aFolder.getFullPath()));
                    ((IFolder)aFolder).create(false, true, null);
                    break block4;
                }
                LOG.debug((Object)("the IContainer passed is neither a folder nor a project: " + aFolder.getFullPath()));
                return false;
            }
            catch (CoreException e) {
                LOG.debug((Object)"folder creation failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

