/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;



/**
 * This interface is used for accessing functionality and information provided
 * by a physicalPackage extension point implementation.
 * 
 * @author rcernich
 *
 * Created on Mar 23, 2004
 */
public interface IPhysicalPackageExtension extends IPackageExtension {
	
	ISupportedServerType getSupportedServerType();

	/**
	 * Uses the minimum version, maximum version, and match rule information
	 * associated with this extension to determine whether or not packages
	 * produced by this extension may be deployed to the specified server
	 * and version.
	 * 
	 * @param type the type of server
	 * 
	 * @return true if this package extension provides support for the specified
	 * server and version.
	 */
	boolean supportsServer(IServerType type);
	
}
