/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

/**
 * @author rcernich
 * 
 * Created on Apr 6, 2004
 */
public abstract class MatchRule {

	public static final MatchRule PERFECT;
	public static final MatchRule EQUIVALENT;
	public static final MatchRule COMPATIBLE;
	public static final MatchRule EQUAL_OR_GREATER;

	public static MatchRule valueOf(String type) {
		MatchRule retVal;
		if (type.equals(PERFECT.mType)) {
			retVal = PERFECT;
		}
		else if (type.equals(EQUIVALENT.mType)) {
			retVal = EQUIVALENT;
		}
		else if (type.equals(COMPATIBLE.mType)) {
			retVal = COMPATIBLE;
		}
		else if (type.equals(EQUAL_OR_GREATER.mType)) {
			retVal = EQUAL_OR_GREATER;
		}
		else {
			// Should throw something here.
			retVal = null;
		}
		return retVal;
	}

	public String toString() {
		return mType;
	}

	private final String mType;

	protected MatchRule(String type) {
		super();
		mType = type;
	}

	static {
		PERFECT = new MatchRule("perfect") { //$NON-NLS-1$
		};
		EQUIVALENT = new MatchRule("equivalent") { //$NON-NLS-1$
		};
		COMPATIBLE = new MatchRule("compatible") { //$NON-NLS-1$
		};
		EQUAL_OR_GREATER = new MatchRule("equalOrGreater") { //$NON-NLS-1$
		};
	}

}