/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.actions.AbstractGroupUngroupAction;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UngroupAction
extends AbstractGroupUngroupAction {
    public static final String ACTION_ID = "ungroupAction";
    public static final String TOOLBAR_ACTION_ID = "toolbarUngroupAction";
    protected static final String ICON_PATH = "icons/Ungroup.gif";
    protected static final String ACTION_TEXT = "Ungroup";
    protected static final String TOOLTIP_TEXT = "Ungroup Shapes(Remove Sub-Process)";
    private List<SubProcessEditPart> subProcesses = new ArrayList<SubProcessEditPart>();

    public UngroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public UngroupAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    private static UngroupAction createActionWithoutId(IWorkbenchPage workbenchPage) {
        UngroupAction action = new UngroupAction(workbenchPage);
        action.setText(ACTION_TEXT);
        action.setToolTipText(TOOLTIP_TEXT);
        action.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor(ICON_PATH));
        return action;
    }

    public static UngroupAction createUngroupAction(IWorkbenchPage workbenchPage) {
        UngroupAction action = UngroupAction.createActionWithoutId(workbenchPage);
        action.setId(ACTION_ID);
        return action;
    }

    public static UngroupAction createToolbarUngroupAction(IWorkbenchPage workbenchPage) {
        UngroupAction action = UngroupAction.createActionWithoutId(workbenchPage);
        action.setId(TOOLBAR_ACTION_ID);
        return action;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        SubProcessEditPart p = this.subProcesses.get(0);
        AbstractTransactionalCommand undoable = new AbstractTransactionalCommand(p.getEditingDomain(), "Ungrouping shapes", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                for (SubProcessEditPart subProcess : UngroupAction.this.subProcesses) {
                    UngroupAction.this.executeUngroupCommand(subProcess);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        p.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)undoable));
    }

    private void executeUngroupCommand(SubProcessEditPart spEditPart) {
        SequenceEdgeEditPart sEdge;
        Activity act;
        SubProcessSubProcessBodyCompartmentEditPart tempComp = null;
        for (Object ep : spEditPart.getChildren()) {
            if (!(ep instanceof SubProcessSubProcessBodyCompartmentEditPart)) continue;
            tempComp = (SubProcessSubProcessBodyCompartmentEditPart)((Object)ep);
            break;
        }
        assert (tempComp != null);
        SubProcessSubProcessBodyCompartmentEditPart compartmentEditPart = tempComp;
        LinkedList<Object> semantic = new LinkedList<Object>();
        LinkedList<View> views = new LinkedList<View>();
        LinkedList removed = new LinkedList();
        for (Object part : compartmentEditPart.getChildren()) {
            semantic.add(((IGraphicalEditPart)part).resolveSemanticElement());
            if (!(((IGraphicalEditPart)part).getModel() instanceof Node)) continue;
            views.add((View)((IGraphicalEditPart)part).getModel());
            removed.addAll(((IGraphicalEditPart)part).getSourceConnections());
            removed.addAll(((IGraphicalEditPart)part).getTargetConnections());
        }
        HashSet edges = new HashSet();
        for (EObject eObject : semantic) {
            if (!(eObject instanceof Vertex)) continue;
            edges.addAll(((Vertex)eObject).getIncomingEdges());
            edges.addAll(((Vertex)eObject).getOutgoingEdges());
        }
        semantic.addAll(edges);
        if (semantic.isEmpty()) {
            return;
        }
        Location location = (Location)((Node)spEditPart.getNotationView()).getLayoutConstraint();
        View targetContainer = ((IGraphicalEditPart)spEditPart.getParent()).getNotationView();
        LinkedList<IGraphicalEditPart> incoming = new LinkedList<IGraphicalEditPart>();
        LinkedList<IGraphicalEditPart> outgoing = new LinkedList<IGraphicalEditPart>();
        UngroupAction.getStartAndEndTasks(spEditPart, outgoing, incoming);
        HashMap inEdges = new HashMap();
        HashMap outEdges = new HashMap();
        for (EObject eObject : semantic) {
            if (!(eObject instanceof Activity)) continue;
            act = (Activity)eObject;
            inEdges.put(act, new ArrayList(act.getIncomingEdges()));
            outEdges.put(act, new ArrayList(act.getOutgoingEdges()));
            act.getIncomingEdges().clear();
            act.getOutgoingEdges().clear();
        }
        for (EObject eObject : semantic) {
            if (eObject instanceof Activity) {
                ((Activity)eObject).setGraph((Graph)targetContainer.getElement());
                continue;
            }
            if (eObject instanceof SequenceEdge) {
                ((Graph)targetContainer.getElement()).getSequenceEdges().add((Object)((SequenceEdge)eObject));
                continue;
            }
            if (eObject instanceof Artifact) {
                ((Graph)targetContainer.getElement()).getArtifacts().add((Object)((Artifact)eObject));
                continue;
            }
            targetContainer.getElement().eContents().add((Object)eObject);
        }
        for (EObject eObject : semantic) {
            if (!(eObject instanceof Activity)) continue;
            act = (Activity)eObject;
            act.getIncomingEdges().addAll((Collection)inEdges.get(act));
            act.getOutgoingEdges().addAll((Collection)outEdges.get(act));
        }
        for (View view : views) {
            spEditPart.getNotationView().removeChild(view);
            targetContainer.insertChild(view);
            if (!(view instanceof Node)) continue;
            Bounds constraint = (Bounds)((Node)view).getLayoutConstraint();
            constraint.setX(constraint.getX() + location.getX());
            constraint.setY(constraint.getY() + location.getY());
            ((Node)view).setLayoutConstraint((LayoutConstraint)constraint);
        }
        Command command = spEditPart.getParent().getCommand(new Request((Object)"refresh"));
        command.execute();
        if (incoming.size() == 1) {
            for (Object edge : spEditPart.getTargetConnections()) {
                if (!(edge instanceof SequenceEdgeEditPart)) continue;
                sEdge = (SequenceEdgeEditPart)((Object)edge);
                for (IGraphicalEditPart part : incoming) {
                    ((SequenceEdge)sEdge.resolveSemanticElement()).setTarget((Vertex)part.resolveSemanticElement());
                    ((Edge)sEdge.getNotationView()).setTarget(part.getNotationView());
                }
            }
        }
        if (outgoing.size() == 1) {
            for (Object edge : spEditPart.getSourceConnections()) {
                if (!(edge instanceof SequenceEdgeEditPart)) continue;
                sEdge = (SequenceEdgeEditPart)((Object)edge);
                for (IGraphicalEditPart part : outgoing) {
                    ((SequenceEdge)sEdge.resolveSemanticElement()).setSource((Vertex)part.resolveSemanticElement());
                    ((Edge)sEdge.getNotationView()).setSource(part.getNotationView());
                }
            }
        }
        Command command2 = spEditPart.getParent().getCommand(new Request((Object)"refresh"));
        command2.execute();
        EditPart parent = spEditPart.getParent();
        DestroyElementRequest request = new DestroyElementRequest(spEditPart.resolveSemanticElement(), false);
        Command destroy = spEditPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)request));
        destroy.execute();
        Command command3 = parent.getCommand(new Request((Object)"refresh"));
        command3.execute();
        for (Object r : removed) {
            ((EditPart)r).refresh();
            ((EditPart)r).activate();
        }
    }

    private static void getStartAndEndTasks(SubProcessEditPart subProcessEditPart, List<IGraphicalEditPart> startElements, List<IGraphicalEditPart> endElements) {
        List children = subProcessEditPart.getChildBySemanticHint(Integer.toString(5002)).getChildren();
        for (Object object : children) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)object;
            List sourceConnections = editPart.getSourceConnections();
            boolean noConnections = true;
            if (!sourceConnections.isEmpty()) {
                for (Object connection : sourceConnections) {
                    if (!(connection instanceof SequenceEdgeEditPart)) continue;
                    noConnections = false;
                    break;
                }
            }
            if (noConnections) {
                startElements.add(editPart);
            }
            List targetConnections = editPart.getTargetConnections();
            noConnections = true;
            if (!targetConnections.isEmpty()) {
                for (Object connection : targetConnections) {
                    if (!(connection instanceof SequenceEdgeEditPart)) continue;
                    noConnections = false;
                    break;
                }
            }
            if (!noConnections) continue;
            endElements.add(editPart);
        }
    }

    public void refresh() {
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        this.subProcesses.clear();
        if (structuredSelection != null) {
            for (Object selElement : structuredSelection.toList()) {
                SubProcess sp;
                EditPart editPart;
                SubProcessEditPart subProcess;
                if (!(selElement instanceof ShapeNodeEditPart) || (subProcess = UngroupAction.getSubProcess(editPart = (EditPart)selElement)) == null || this.subProcesses.contains((Object)subProcess) || !(sp = (SubProcess)subProcess.resolveSemanticElement()).getEventHandlers().isEmpty() || sp.getVertices().isEmpty()) continue;
                this.subProcesses.add(subProcess);
            }
            this.subProcesses = ToolUtilities.getSelectionWithoutDependants(this.subProcesses);
        }
        this.setEnabled(!this.subProcesses.isEmpty());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

