/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnDecorationFilterService {
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private static BpmnDecorationFilterService instance;

    private BpmnDecorationFilterService() {
        this.init();
    }

    public static BpmnDecorationFilterService getInstance() {
        if (instance == null) {
            instance = new BpmnDecorationFilterService();
        }
        return instance;
    }

    private void init() {
        IConfigurationElement[] configElems = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.stp.bpmn.diagram.DecorationFilter");
        int j = configElems.length - 1;
        while (j >= 0) {
            try {
                this.parseFilter(configElems[j]);
            }
            catch (Exception e) {
                BpmnDiagramEditorPlugin.getInstance().logError(e.getMessage(), e);
            }
            --j;
        }
        String configuration = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getString(BpmnDiagramPreferenceInitializer.FILTERS_STATES);
        String[] stringArray = configuration.split(";");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            Filter filter;
            String filterInformation = stringArray[n];
            String[] filterSplit = filterInformation.split(",");
            if (filterSplit.length == 2 && (filter = this.filters.get(filterSplit[0])) != null) {
                filter.active = Boolean.parseBoolean(filterSplit[1]);
            }
            ++n;
        }
    }

    private void parseFilter(IConfigurationElement element) {
        Filter filter = new Filter();
        filter.id = element.getAttribute("id");
        filter.name = element.getAttribute("name");
        filter.onByDefault = Boolean.parseBoolean(element.getAttribute("onByDefault"));
        filter.active = filter.onByDefault;
        String iconName = element.getAttribute("icon");
        if (iconName != null) {
            ImageDescriptor imageDesc;
            filter.image = imageDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)iconName);
        }
        IConfigurationElement[] iConfigurationElementArray = element.getChildren("source");
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement source = iConfigurationElementArray[n];
            filter.sources.add(source.getAttribute("value"));
            ++n;
        }
        iConfigurationElementArray = element.getChildren("marker");
        n = 0;
        n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement markerType = iConfigurationElementArray[n];
            MarkerFilter markerFilter = new MarkerFilter();
            markerFilter.markerType = markerType.getAttribute("type");
            markerFilter.code = markerType.getAttribute("code");
            filter.markers.add(markerFilter);
            ++n;
        }
        if (!(filter.id == null || filter.sources.isEmpty() && filter.markers.isEmpty())) {
            this.filters.put(filter.id, filter);
        }
    }

    public boolean isSourceFiltered(String annotationSource) {
        for (Filter filter : this.filters.values()) {
            if (!filter.active || !filter.sources.contains(annotationSource)) continue;
            return true;
        }
        return false;
    }

    public boolean isMarkerFiltered(String markerType, Object code) {
        String codeAsString = code == null ? null : code.toString();
        for (Filter filter : this.filters.values()) {
            if (!filter.active) continue;
            for (MarkerFilter markerFilter : filter.markers) {
                if (!markerFilter.equals(markerType) || codeAsString != null && !codeAsString.equals(markerFilter.code)) continue;
                return true;
            }
        }
        return false;
    }

    public void filterChanged(String filterId) {
        Filter filter = this.filters.get(filterId);
        assert (filter != null);
        filter.active = !filter.active;
        this.saveFilterValues();
    }

    private void saveFilterValues() {
        StringBuffer buffer = new StringBuffer();
        for (Filter filter : this.filters.values()) {
            buffer.append(String.valueOf(filter.id) + "," + filter.active + ";");
        }
        BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().setValue(BpmnDiagramPreferenceInitializer.FILTERS_STATES, buffer.toString());
    }

    public Set<String> getCurrentFilters() {
        return this.filters.keySet();
    }

    public String getFilterName(String id) {
        return this.filters.get(id) == null ? null : this.filters.get(id).name;
    }

    public ImageDescriptor getFilterImageDescriptor(String id) {
        return this.filters.get(id) == null ? null : this.filters.get((Object)id).image;
    }

    public boolean isFilterActive(String filterId) {
        return this.filters.get(filterId) == null ? false : this.filters.get(filterId).active;
    }

    private class Filter {
        private String id;
        private List<String> sources = new ArrayList<String>();
        private List<MarkerFilter> markers = new ArrayList<MarkerFilter>();
        private boolean onByDefault;
        private boolean active = false;
        private String name;
        public ImageDescriptor image;

        private Filter() {
        }
    }

    private class MarkerFilter {
        private String markerType;
        private String code;

        private MarkerFilter() {
        }

        public boolean equals(Object object) {
            if (object instanceof String) {
                return ((String)object).equals(this.markerType);
            }
            return super.equals(object);
        }
    }
}

