/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.introspection;

import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.IEMFWorkbenchContextFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.internal.introspection.ComponentTypeResourceAssistantFactory;
import org.eclipse.stp.core.resources.ComponentTypeScribblerDomain;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.tests.introspection.AssertNotificationAdapter;
import org.eclipse.stp.core.tests.introspection.PropertiesSharedModel;
import org.eclipse.stp.core.tests.util.TestWorkspace;

public class IntrospectionWithoutComponentTests
extends TestCase {
    private static final String ORG_ACME_TEST_INTERFACE = "org.acme.TestInterface";
    private static final String EXPECTED_PROP_TYPE_VALUE = "java.lang.String";
    private static final String EXPECTED_PROPERTY_NAME = "SimpleProperty";
    private static final String EXPECTED_REFERENCE_NAME = "SimpleReference";
    private static final String EXPECTED_SERVICE_NAME = "SimpleService";
    private IProject testProject;
    private IFile propertyComponentTypeFile;

    public IntrospectionWithoutComponentTests(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(IntrospectionWithoutComponentTests.class);
        return suite;
    }

    protected void setUp() throws Exception {
        TestWorkspace.init();
        IEMFWorkbenchContextFactory.eINSTANCE.installResourceAssistantFactory(ComponentTypeResourceAssistantFactory.getInstance());
        this.testProject = TestWorkspace.getComponentTypeIntrospectorTestProject();
        this.propertyComponentTypeFile = this.testProject.getFile("MyValueComponent.properties");
        PropertiesSharedModel.NotifyingProperties props = PropertiesSharedModel.getProperties(this.propertyComponentTypeFile);
        PropertiesSharedModel.createNewService(props, EXPECTED_SERVICE_NAME, ORG_ACME_TEST_INTERFACE);
        PropertiesSharedModel.createNewReference(props, EXPECTED_REFERENCE_NAME, ORG_ACME_TEST_INTERFACE);
        PropertiesSharedModel.createNewProperty(props, EXPECTED_PROPERTY_NAME, EXPECTED_PROP_TYPE_VALUE);
        PropertiesSharedModel.saveProperties(props);
    }

    protected void tearDown() throws Exception {
        TestWorkspace.getComponentTypeIntrospectorTestProject().delete(true, null);
    }

    public void testComponentTypeIntrospectionServices() throws Exception {
        Object rootObject;
        ComponentTypeScribblerDomain domain = new ComponentTypeScribblerDomain(this.propertyComponentTypeFile);
        IEditModelScribbler scribbler = domain.createScribblerForRead();
        Resource r = scribbler.getResource((IResourceDescriptor)domain.getComponentTypeDescriptor());
        if (r.getContents().size() > 0 && (rootObject = r.getContents().get(0)) instanceof SCACoreRoot) {
            SCACoreRoot root = (SCACoreRoot)r.getContents().get(0);
            ComponentType componentType = root.getComponentType();
            if (componentType == null) {
                IntrospectionWithoutComponentTests.fail((String)"ComponentType expected");
            }
            AssertNotificationAdapter assertAdapter = new AssertNotificationAdapter();
            componentType.getEObject().eAdapters().add((Object)assertAdapter);
            List services = componentType.getServices();
            assertAdapter.assertNoNotifications("No notifications should be generated when fetching services for the first time.");
            componentType.getEObject().eAdapters().remove((Object)assertAdapter);
            IntrospectionWithoutComponentTests.assertTrue((services.size() > 0 ? 1 : 0) != 0);
            Service service = (Service)services.get(0);
            IntrospectionWithoutComponentTests.assertEquals((String)"The service name should match the expected value.", (String)EXPECTED_SERVICE_NAME, (String)service.getName());
            IntrospectionWithoutComponentTests.assertTrue((String)"The service should have a Java Interface.", (boolean)(service.getInterface() instanceof JavaInterface));
            JavaInterface jifze = (JavaInterface)service.getInterface();
            IntrospectionWithoutComponentTests.assertEquals((String)"The Java interface should be the expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)jifze.getInterface());
            List references = componentType.getReferences();
            IntrospectionWithoutComponentTests.assertTrue((references.size() > 0 ? 1 : 0) != 0);
            Reference reference = (Reference)references.get(0);
            IntrospectionWithoutComponentTests.assertEquals((String)"The reference name should match the expected value.", (String)EXPECTED_REFERENCE_NAME, (String)reference.getName());
            IntrospectionWithoutComponentTests.assertTrue((String)"The reference should have a Java Interface.", (boolean)(reference.getInterface() instanceof JavaInterface));
            JavaInterface refJifze = (JavaInterface)reference.getInterface();
            IntrospectionWithoutComponentTests.assertEquals((String)"The Java interface of reference should be expected value.", (String)ORG_ACME_TEST_INTERFACE, (String)refJifze.getInterface());
            List properties = componentType.getProperties();
            IntrospectionWithoutComponentTests.assertTrue((properties.size() > 0 ? 1 : 0) != 0);
            Property property = (Property)properties.get(0);
            IntrospectionWithoutComponentTests.assertEquals((String)"The property name should match the expected value.", (String)EXPECTED_PROPERTY_NAME, (String)property.getName());
            IntrospectionWithoutComponentTests.assertEquals((String)"The property default value should match expected value.", (String)property.getDefault(), (String)EXPECTED_PROP_TYPE_VALUE);
        }
        scribbler.close(null);
    }
}

