/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.introspection;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.core.introspection.IDynamicModelIntrospector;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;

public class PropertiesLightweightParser {
    private final SCAPackage scaPackage = SCAPackage.eINSTANCE;
    private IDynamicModelIntrospector modelHandler;
    private ComponentType componentType;

    public PropertiesLightweightParser(IDynamicModelIntrospector aModelHandler, ComponentType aComponentType) {
        this.modelHandler = aModelHandler;
        this.componentType = aComponentType;
    }

    public void begin() {
        this.modelHandler.startIntrospection((EStructuralFeature)this.scaPackage.getSCACoreRoot_ComponentType(), (SCAObject)this.componentType);
    }

    public void end() {
        this.modelHandler.endIntrospection();
    }

    public void createService(String serviceName, String interfaceName) {
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getComponentType_Services(), this.scaPackage.getService(), (EStructuralFeature)this.scaPackage.getComponentType_Services());
        this.modelHandler.attribute(this.scaPackage.getService_Name(), (Object)serviceName, false);
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getService_Interface(), this.scaPackage.getJavaInterface(), (EStructuralFeature)this.scaPackage.getSCACoreRoot_InterfaceJava());
        this.modelHandler.attribute(this.scaPackage.getJavaInterface_Interface(), (Object)interfaceName, true);
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getService_Interface());
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getComponentType_Services());
    }

    public void deleteService(String serviceName, String interfaceName) {
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getComponentType_Services(), this.scaPackage.getService(), (EStructuralFeature)this.scaPackage.getComponentType_Services(), 8);
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getService_Interface(), this.scaPackage.getJavaInterface(), (EStructuralFeature)this.scaPackage.getSCACoreRoot_InterfaceJava());
        this.modelHandler.attribute(this.scaPackage.getJavaInterface_Interface(), (Object)interfaceName, true);
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getService_Interface());
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getComponentType_Services());
    }

    public void createReference(String referenceName, String interfaceName, String multiplicity) {
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getComponentType_References(), this.scaPackage.getReference(), (EStructuralFeature)this.scaPackage.getComponentType_References());
        this.modelHandler.attribute(this.scaPackage.getReference_Name(), (Object)referenceName, true);
        this.modelHandler.attribute(this.scaPackage.getReference_Multiplicity(), (Object)multiplicity, false);
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getReference_Interface(), this.scaPackage.getJavaInterface(), (EStructuralFeature)this.scaPackage.getSCACoreRoot_InterfaceJava());
        this.modelHandler.attribute(this.scaPackage.getJavaInterface_Interface(), (Object)interfaceName, false);
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getReference_Interface());
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getComponentType_References());
    }

    public void deleteReference(String referenceName) {
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getComponentType_References(), this.scaPackage.getReference(), (EStructuralFeature)this.scaPackage.getComponentType_References(), 8);
        this.modelHandler.attribute(this.scaPackage.getReference_Name(), (Object)referenceName, true);
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getComponentType_References());
    }

    public void createProperty(String propertyName, String type, boolean isMany, boolean isRequired, String defaultValue) {
        this.modelHandler.startFeature((EStructuralFeature)this.scaPackage.getComponentType_Properties(), this.scaPackage.getProperty(), (EStructuralFeature)this.scaPackage.getComponentType_Properties());
        this.modelHandler.attribute(this.scaPackage.getProperty_Name(), (Object)propertyName, true);
        this.modelHandler.attribute(this.scaPackage.getProperty_Type(), (Object)type, false);
        this.modelHandler.attribute(this.scaPackage.getProperty_Many(), (Object)isMany, false);
        this.modelHandler.attribute(this.scaPackage.getProperty_Required(), (Object)isRequired, false);
        this.modelHandler.attribute(this.scaPackage.getProperty_Default(), (Object)defaultValue, false);
        this.modelHandler.endFeature((EStructuralFeature)this.scaPackage.getComponentType_Properties());
    }

    public void removeUntouchedReferences() {
        this.modelHandler.removeUntouched((EStructuralFeature)this.scaPackage.getComponentType_References());
    }

    public void removeUntouchedServices() {
        this.modelHandler.removeUntouched((EStructuralFeature)this.scaPackage.getComponentType_Services());
    }

    public void removeUntouchedProperties() {
        this.modelHandler.removeUntouched((EStructuralFeature)this.scaPackage.getComponentType_Properties());
    }
}

