/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.ComponentWireHandle;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Flags;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;
import org.eclipse.stp.core.tests.util.AssertionSAXHandler;
import org.eclipse.stp.core.tests.util.XMLAssertions;

public class CompositeWireTests
extends TestCase {
    private static final String PROJECT_NAME = "CompositeWireTests";
    private IProject project;

    public CompositeWireTests() {
    }

    public CompositeWireTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    public void testSimpleExternalServiceResolution() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"CompositeWireTests/t1.composite");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Module composite = fact.createModule();
        composite.setName("T1Composite");
        root.setModule(composite);
        ExternalService extService = fact.createExternalService();
        extService.setName("ext_service1");
        composite.getExternalServices().add(extService);
        Component comp = fact.createComponent();
        comp.setName("component1");
        composite.getComponents().add(comp);
        ComponentType compType = fact.createComponentType();
        Reference ref = fact.createReference();
        ref.setName("ref1");
        compType.getReferences().add(ref);
        comp.setAbstractImplementation(compType);
        WireSource ref1Source = comp.getWireSource("ref1");
        CompositeWireTests.assertNotNull((Object)ref1Source);
        CompositeWireTests.assertTrue((boolean)ref1Source.isResolved());
        CompositeWireTests.assertFalse((boolean)Flags.isBoundaryElement((int)ref1Source.getFlags()));
        CompositeWireTests.assertTrue((((ComponentWireHandle)ref1Source).getOwningComponent() == comp ? 1 : 0) != 0);
        WireTarget target = composite.resolveWireTarget("ext_service1");
        CompositeWireTests.assertNotNull((Object)target);
        CompositeWireTests.assertTrue((boolean)target.isResolved());
        CompositeWireTests.assertTrue((boolean)Flags.isBoundaryElement((int)target.getFlags()));
        WireSource bogusSource = comp.getWireSource("foo");
        CompositeWireTests.assertNotNull((Object)bogusSource);
        CompositeWireTests.assertFalse((boolean)bogusSource.isResolved());
        CompositeWireTests.assertTrue((boolean)bogusSource.isComponentOwned());
        CompositeWireTests.assertTrue((((ComponentWireHandle)bogusSource).getOwningComponent() == comp ? 1 : 0) != 0);
        CompositeWireTests.assertEquals((String)"component1/foo", (String)bogusSource.getName());
        WireTarget bogusTarget = composite.resolveWireTarget("fooComp/bar");
        CompositeWireTests.assertNotNull((Object)bogusTarget);
        CompositeWireTests.assertFalse((boolean)bogusTarget.isComponentOwned());
        CompositeWireTests.assertFalse((boolean)bogusTarget.isResolved());
        CompositeWireTests.assertEquals((String)"fooComp/bar", (String)bogusTarget.getName());
        bogusTarget = composite.resolveWireTarget("test/");
        CompositeWireTests.assertNotNull((Object)bogusTarget);
        CompositeWireTests.assertFalse((boolean)bogusTarget.isComponentOwned());
        CompositeWireTests.assertFalse((boolean)bogusTarget.isResolved());
        CompositeWireTests.assertEquals((String)"test/", (String)bogusTarget.getName());
        ref1Source.createWireToTarget(target);
        List targets = ref1Source.getWiredTargets();
        CompositeWireTests.assertNotNull((Object)targets);
        CompositeWireTests.assertTrue((targets.size() == 1 ? 1 : 0) != 0);
        WireTarget newTarget = (WireTarget)targets.get(0);
        CompositeWireTests.assertEquals((String)"ext_service1", (String)newTarget.getName());
        List refValues = comp.getReferenceValues("ref1");
        CompositeWireTests.assertTrue((refValues.size() == 1 ? 1 : 0) != 0);
        ReferenceValue refValue = (ReferenceValue)refValues.get(0);
        CompositeWireTests.assertEquals((String)"ref1", (String)refValue.getName());
        CompositeWireTests.assertEquals((String)"ext_service1", (String)refValue.getTargetURI());
        Reference resovledRef = refValue.getReference();
        CompositeWireTests.assertNotNull((Object)resovledRef);
        WireTarget resolvedTarget = refValue.getTarget();
        CompositeWireTests.assertNotNull((Object)resolvedTarget);
        CompositeWireTests.assertEquals((String)"ext_service1", (String)resolvedTarget.getName());
        res.save(null);
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        CompositeWireTests.assertTrue((boolean)ref1Source.deleteWireToTarget(target));
        CompositeWireTests.assertTrue((ref1Source.getWiredTargets().size() == 0 ? 1 : 0) != 0);
        CompositeWireTests.assertTrue((boolean)comp.getReferenceValues().isEmpty());
    }

    public void testSimpleEntryPointResolution() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"CompositeWireTests/simpleEntryPoint.composite");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Composite composite = fact.createComposite();
        composite.setName("EntryPointModule");
        root.setComposite(composite);
        EntryPoint entPt = fact.createEntryPoint();
        entPt.setName("entPt1");
        composite.getEntryPoints().add(entPt);
        Component comp = fact.createComponent();
        comp.setName("component1");
        composite.getComponents().add(comp);
        ComponentType compType = fact.createComponentType();
        Service serv = fact.createService();
        serv.setName("s1");
        compType.getServices().add(serv);
        comp.setAbstractImplementation(compType);
        WireSource source = composite.resolveWireSource("entPt1");
        CompositeWireTests.assertNotNull((Object)source);
        CompositeWireTests.assertFalse((boolean)source.isComponentOwned());
        CompositeWireTests.assertTrue((boolean)Flags.isBoundaryElement((int)source.getFlags()));
        CompositeWireTests.assertTrue((boolean)source.isResolved());
        CompositeWireTests.assertTrue((boolean)source.getWiredTargets().isEmpty());
        WireTarget target = composite.resolveWireTarget("component1/s1");
        CompositeWireTests.assertNotNull((Object)target);
        source.createWireToTarget(target);
        List targets = source.getWiredTargets();
        CompositeWireTests.assertNotNull((Object)targets);
        CompositeWireTests.assertTrue((targets.size() == 1 ? 1 : 0) != 0);
        WireTarget newTarget = (WireTarget)targets.get(0);
        CompositeWireTests.assertEquals((String)"component1/s1", (String)newTarget.getName());
        res.save(null);
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        CompositeWireTests.assertTrue((boolean)source.deleteWireToTarget(newTarget));
        CompositeWireTests.assertTrue((boolean)source.getWiredTargets().isEmpty());
        List refTargets = ((EntryPoint)source).getReferenceTargets();
        CompositeWireTests.assertTrue((boolean)refTargets.isEmpty());
    }

    public void testStringReferenceValueResolution() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"CompositeWireTests/t2.composite");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Module module = fact.createModule();
        module.setName("T2Composite");
        root.setComposite((Composite)module);
        ExternalService extService = fact.createExternalService();
        extService.setName("ext_service1");
        module.getExternalServices().add(extService);
        Component comp = fact.createComponent();
        comp.setName("component1");
        module.getComponents().add(comp);
        ComponentType compType = fact.createComponentType();
        Reference ref1 = fact.createReference();
        ref1.setName("ref1");
        compType.getReferences().add(ref1);
        Reference ref2 = fact.createReference();
        ref2.setName("ref2");
        compType.getReferences().add(ref2);
        comp.setAbstractImplementation(compType);
        Component comp2 = fact.createComponent();
        comp2.setName("component2");
        module.getComponents().add(comp2);
        compType = fact.createComponentType();
        Service s1 = fact.createService();
        s1.setName("s1");
        compType.getServices().add(s1);
        comp2.setAbstractImplementation(compType);
        ReferenceValue refValue1 = fact.createReferenceValue();
        refValue1.setName("ref1");
        refValue1.setTargetURI("ext_service1");
        comp.getReferenceValues().add(refValue1);
        ReferenceValue refValue2 = fact.createReferenceValue();
        refValue2.setName("ref2");
        refValue2.setTargetURI("component2/s1");
        comp.getReferenceValues().add(refValue2);
        List values = comp.getReferenceValues("ref1");
        CompositeWireTests.assertTrue((values.size() == 1 ? 1 : 0) != 0);
        ReferenceValue rv = (ReferenceValue)values.get(0);
        Reference r1 = rv.getReference();
        CompositeWireTests.assertNotNull((Object)r1);
        CompositeWireTests.assertEquals((String)"ref1", (String)r1.getName());
        WireTarget t1 = rv.getTarget();
        CompositeWireTests.assertNotNull((Object)t1);
        CompositeWireTests.assertEquals((String)"ext_service1", (String)t1.getName());
        values = comp.getReferenceValues("ref2");
        CompositeWireTests.assertTrue((values.size() == 1 ? 1 : 0) != 0);
        rv = (ReferenceValue)values.get(0);
        Reference r2 = rv.getReference();
        CompositeWireTests.assertNotNull((Object)r2);
        CompositeWireTests.assertEquals((String)"ref2", (String)r2.getName());
        WireTarget t2 = rv.getTarget();
        CompositeWireTests.assertNotNull((Object)t2);
        CompositeWireTests.assertTrue((boolean)t2.isResolved());
        CompositeWireTests.assertEquals((String)"component2/s1", (String)t2.getName());
        ReferenceValue bogusValue = fact.createReferenceValue();
        bogusValue.setName("bogus");
        bogusValue.setTargetURI("component222/s1");
        comp2.getReferenceValues().add(bogusValue);
        values = comp2.getReferenceValues("bogus");
        CompositeWireTests.assertTrue((values.size() == 1 ? 1 : 0) != 0);
        rv = (ReferenceValue)values.get(0);
        Reference r = rv.getReference();
        CompositeWireTests.assertNull((Object)r);
        WireTarget t = rv.getTarget();
        CompositeWireTests.assertNotNull((Object)t);
        CompositeWireTests.assertFalse((boolean)t.isResolved());
        CompositeWireTests.assertEquals((String)"component222/s1", (String)t.getName());
        res.save(null);
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        WireSource ref1Source = comp.getWireSource("ref1");
        CompositeWireTests.assertNotNull((Object)ref1Source);
        CompositeWireTests.assertTrue((boolean)ref1Source.isResolved());
        CompositeWireTests.assertTrue((boolean)ref1Source.deleteWireToTarget(t1));
        CompositeWireTests.assertFalse((boolean)ref1Source.deleteWireToTarget(t));
        CompositeWireTests.assertTrue((boolean)ref1Source.getWiredTargets().isEmpty());
        CompositeWireTests.assertTrue((comp.getReferenceValues().size() == 1 ? 1 : 0) != 0);
        CompositeWireTests.assertEquals((String)"ref2", (String)((ReferenceValue)comp.getReferenceValues().get(0)).getName());
        WireSource ref2Source = comp.getWireSource("ref2");
        CompositeWireTests.assertNotNull((Object)ref2Source);
        CompositeWireTests.assertTrue((boolean)ref2Source.isResolved());
        CompositeWireTests.assertFalse((boolean)ref2Source.getWiredTargets().isEmpty());
        CompositeWireTests.assertTrue((boolean)ref2Source.deleteWireToTarget(t2));
        CompositeWireTests.assertTrue((boolean)ref2Source.getWiredTargets().isEmpty());
        CompositeWireTests.assertTrue((boolean)comp.getReferenceValues().isEmpty());
    }

    public void testDeleteAllWiresForTarget() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"CompositeWireTests/testDeleteAll.composite");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Module composite = fact.createModule();
        composite.setName("T33Composite");
        root.setModule(composite);
        Component comp = fact.createComponent();
        comp.setName("component1");
        composite.getComponents().add(comp);
        ComponentType compType = fact.createComponentType();
        Service s1 = fact.createService();
        s1.setName("s1");
        compType.getServices().add(s1);
        comp.setAbstractImplementation(compType);
        Component comp2 = fact.createComponent();
        comp.setName("component2");
        composite.getComponents().add(comp2);
        ComponentType compType2 = fact.createComponentType();
        Reference r1 = fact.createReference();
        r1.setName("r1");
        compType2.getReferences().add(r1);
        comp2.setAbstractImplementation(compType2);
        Component comp3 = fact.createComponent();
        comp.setName("component3");
        composite.getComponents().add(comp3);
        ComponentType compType3 = fact.createComponentType();
        Reference r3 = fact.createReference();
        r3.setName("r3");
        compType3.getReferences().add(r3);
        comp3.setAbstractImplementation(compType3);
        EntryPoint ep = fact.createEntryPoint();
        ep.setName("ep");
        composite.getEntryPoints().add(ep);
        WireTarget target = comp.getWireTarget("s1");
        CompositeWireTests.assertTrue((boolean)target.isResolved());
        ep.createWireToTarget(target);
        WireSource c2Source = comp2.getSingleWireSource();
        CompositeWireTests.assertTrue((boolean)c2Source.isResolved());
        c2Source.createWireToTarget(target);
        CompositeWireTests.assertTrue((comp2.getReferenceValues("r1").size() == 1 ? 1 : 0) != 0);
        WireSource c3Source = comp3.getSingleWireSource();
        CompositeWireTests.assertTrue((boolean)c3Source.isResolved());
        c3Source.createWireToTarget(target);
        CompositeWireTests.assertTrue((comp3.getReferenceValues("r3").size() == 1 ? 1 : 0) != 0);
        res.save(null);
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        Collection allSources = composite.getAllWiredSources(target);
        CompositeWireTests.assertTrue((allSources.size() == 3 ? 1 : 0) != 0);
        Iterator it = allSources.iterator();
        while (it.hasNext()) {
            CompositeWireTests.assertTrue((boolean)((WireSource)it.next()).deleteWireToTarget(target));
        }
        allSources = composite.getAllWiredSources(target);
        CompositeWireTests.assertTrue((boolean)allSources.isEmpty());
    }

    public void testDeleteReferenceForWireSource() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"CompositeWireTests/testRefDelete.composite");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Module composite = fact.createModule();
        composite.setName("Composite1");
        root.setModule(composite);
        Component comp = fact.createComponent();
        comp.setName("component1");
        composite.getComponents().add(comp);
        ComponentType compType = fact.createComponentType();
        Service s1 = fact.createService();
        s1.setName("s1");
        compType.getServices().add(s1);
        comp.setAbstractImplementation(compType);
        ExternalService extServ = fact.createExternalService();
        extServ.setName("ExtServ1");
        composite.getExternalServices().add(extServ);
        Component comp2 = fact.createComponent();
        comp2.setName("component2");
        composite.getComponents().add(comp2);
        ComponentType compType2 = fact.createComponentType();
        Reference c2R1 = fact.createReference();
        c2R1.setName("c2R1");
        compType2.getReferences().add(c2R1);
        Reference c2R2 = fact.createReference();
        c2R2.setName("c2R2");
        compType2.getReferences().add(c2R2);
        comp2.setAbstractImplementation(compType2);
        WireSource source1 = comp2.getWireSource(c2R1);
        CompositeWireTests.assertTrue((boolean)source1.isResolved());
        WireSource source2 = comp2.getWireSource(c2R2);
        CompositeWireTests.assertTrue((boolean)source2.isResolved());
        source1.createWireToTarget((WireTarget)extServ);
        CompositeWireTests.assertFalse((boolean)source1.getWiredTargets().isEmpty());
        source2.createWireToTarget(comp.getSingleWireTarget());
        CompositeWireTests.assertFalse((boolean)source2.getWiredTargets().isEmpty());
        compType2.getReferences().clear();
        CompositeWireTests.assertFalse((boolean)source1.isResolved());
        CompositeWireTests.assertFalse((boolean)source1.getWiredTargets().isEmpty());
        CompositeWireTests.assertFalse((boolean)source2.isResolved());
        CompositeWireTests.assertFalse((boolean)source2.getWiredTargets().isEmpty());
        source1 = null;
        source2 = null;
        source1 = comp2.getWireSource("c2R1");
        CompositeWireTests.assertNotNull((Object)source1);
        source2 = comp2.getWireSource("c2R2");
        CompositeWireTests.assertNotNull((Object)source2);
        CompositeWireTests.assertTrue((boolean)source1.deleteWireToTarget((WireTarget)extServ));
        CompositeWireTests.assertTrue((boolean)source2.deleteWireToTarget(comp.getSingleWireTarget()));
        source1 = null;
        source2 = null;
        source1 = comp2.getWireSource("c2R1");
        CompositeWireTests.assertNotNull((Object)source1);
        CompositeWireTests.assertFalse((boolean)source1.isResolved());
        source2 = comp2.getWireSource("c2R2");
        CompositeWireTests.assertNotNull((Object)source2);
        CompositeWireTests.assertFalse((boolean)source2.isResolved());
        WireTarget target1 = comp2.getWireTarget("c2R1");
        CompositeWireTests.assertTrue((boolean)(target1 instanceof WireTarget));
    }
}

