/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.annvalidator;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.annvalidator.anntree.AnnXMLTreeBuilder;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.w3c.dom.Document;

public class AnnXMLTreeBuilderTest
extends TestCase {
    private static String PROJECT_NAME = "ANNXMLTreeBuilderTestPrj";
    private static String TEST_FILE_PATH = "/src/demo/GreeterRPCLit.java";
    private static String RES_FILE_PATH = "/resources/GreeterRPCLit.java_resource";
    AnnXMLTreeBuilder builder;
    protected IProject project;
    protected IFile testFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = new AnnXMLTreeBuilder();
        this.project = WorkbenchUtils.createTestCeltixProject((String)PROJECT_NAME);
        WorkbenchUtils.setupBasicJavaProject((IProject)this.project);
        this.testFile = this.project.getFile(TEST_FILE_PATH);
        if (!this.testFile.exists()) {
            WorkbenchUtils.addFileResourceToTestProject((IProject)this.project, (String)TEST_FILE_PATH, ((Object)((Object)this)).getClass(), (String)RES_FILE_PATH);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoadXMLFile() throws Exception {
        Document doc = this.builder.loadXMLFile(this.testFile);
        AnnXMLTreeBuilderTest.assertNotNull((String)"should created xml doc", (Object)doc);
        AnnXMLTreeBuilderTest.assertTrue((String)"has 1Class.", (doc.getElementsByTagName("Class").getLength() == 1 ? 1 : 0) != 0);
        AnnXMLTreeBuilderTest.assertTrue((String)"has 2 methods.", (doc.getElementsByTagName("Method").getLength() == 2 ? 1 : 0) != 0);
        AnnXMLTreeBuilderTest.assertTrue((String)"has 1 webservice.", (doc.getElementsByTagName("WebService").getLength() == 1 ? 1 : 0) != 0);
        AnnXMLTreeBuilderTest.assertTrue((String)"has 2 webmethod.", (doc.getElementsByTagName("WebMethod").getLength() == 2 ? 1 : 0) != 0);
        AnnXMLTreeBuilderTest.assertTrue((String)"has 1 SOAPBinding.", (doc.getElementsByTagName("SOAPBinding").getLength() == 1 ? 1 : 0) != 0);
        AnnXMLTreeBuilderTest.assertTrue((String)"has 2 WebResult.", (doc.getElementsByTagName("WebResult").getLength() == 2 ? 1 : 0) != 0);
        AnnXMLTreeBuilderTest.assertTrue((String)"has 2 WebParame.", (doc.getElementsByTagName("WebParam").getLength() == 1 ? 1 : 0) != 0);
    }
}

