/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class JarUtils {
    public static String PATH_SEPERATOR = "/";

    public static JarOutputStream createJarOutputStream(String filePath) throws IOException {
        return JarUtils.createJarOutputStream(filePath, null);
    }

    public static JarOutputStream createJarOutputStream(String filePath, String manifestPath) throws IOException {
        File targetFile = new File(filePath);
        FileOutputStream fos = new FileOutputStream(targetFile);
        if (manifestPath == null) {
            return new JarOutputStream((OutputStream)fos, new Manifest());
        }
        FileInputStream fis = new FileInputStream(manifestPath);
        return new JarOutputStream((OutputStream)fos, new Manifest(fis));
    }

    public static void addOneTargetDir(JarOutputStream output, IFolder folderToAdd, String targetPath) throws CoreException, IOException {
        if (folderToAdd != null && folderToAdd.exists()) {
            IResource[] iResourceArray = folderToAdd.members();
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                IResource member = iResourceArray[n];
                if (member.getType() == 2) {
                    String filePath = targetPath;
                    if (!filePath.equals("") && !filePath.endsWith(PATH_SEPERATOR)) {
                        filePath = String.valueOf(filePath) + PATH_SEPERATOR;
                    }
                    filePath = String.valueOf(filePath) + member.getName();
                    JarUtils.addOneTargetDir(output, (IFolder)member, filePath);
                } else if (member.getType() == 1) {
                    String targetName = member.getName();
                    if (!targetPath.trim().equals("")) {
                        targetName = String.valueOf(targetPath) + PATH_SEPERATOR + member.getName();
                    }
                    JarUtils.addToJar(output, targetName, (IFile)member);
                }
                ++n;
            }
        }
    }

    public static void addToJar(JarOutputStream output, String fileName, IFile targetFile) throws IOException {
        JarUtils.addToJar(output, fileName, targetFile.getRawLocation().toOSString());
    }

    public static void addToJar(JarOutputStream output, String fileName, String filePath) throws IOException {
        JarEntry jarAdd = new JarEntry(fileName);
        File file = new File(filePath);
        jarAdd.setTime(file.lastModified());
        output.putNextEntry(jarAdd);
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[10240];
        int read = 0;
        while ((read = in.read(buffer, 0, buffer.length)) > 0) {
            output.write(buffer, 0, read);
        }
        in.close();
    }
}

