/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceManager {
    public static final String WSDL_FOLDER = "wsdl";
    public static final String SRC_FOLDER = "src";
    public static final String CLASSES_FOLDER = "classes";
    public static final String META_INF_DIR = "META-INF";
    public static final String META_INF_FILENAME = "MANIFEST.MF";
    public static final String BIN_DIR = "bin";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WorkspaceManager.class);

    protected WorkspaceManager() {
    }

    protected static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder.exists()) {
            return;
        }
        folder.create(true, true, monitor);
    }

    public static boolean hasBuilder(IProject project, String builderID) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addBuilder(IProject project, String builderID, BuilderOrder order) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        ICommand newCommand = desc.newCommand();
        newCommand.setBuilderName(builderID);
        int index = 0;
        if (order == BuilderOrder.FIRST) {
            newCommands[index++] = newCommand;
        }
        System.arraycopy(commands, 0, newCommands, index, commands.length);
        if (order == BuilderOrder.LAST) {
            newCommands[newCommands.length - 1] = newCommand;
        }
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    public static void removeBuilder(IProject project, String builderID) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                break;
            }
            ++i;
        }
        project.setDescription(description, null);
    }

    public static IFolder getMetaInfFolder(IProject hostProject) {
        return hostProject.getFolder(META_INF_DIR);
    }

    public static IFolder getBinFolder(IProject hostProject) {
        return hostProject.getFolder(BIN_DIR);
    }

    public static IFile getManiInfFile(IProject hostProject) {
        return WorkspaceManager.getMetaInfFolder(hostProject).getFile(META_INF_FILENAME);
    }

    public static void copyFilesInFolder(IContainer originalFolder, IFolder destFolder, HashSet<String> extensions, IProgressMonitor monitor) throws CoreException, IOException {
        IResource[] resources;
        IResource[] iResourceArray = resources = originalFolder.members();
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            IResource res = iResourceArray[n];
            if (res instanceof IFile) {
                if (extensions == null || extensions.contains(res.getFileExtension())) {
                    WorkspaceManager.copyFile((IFile)res, destFolder, monitor);
                }
            } else if (res instanceof IFolder) {
                IFolder childFolder = (IFolder)res;
                IFolder childDestFolder = destFolder.getFolder(childFolder.getName());
                if (childDestFolder.exists()) {
                    childDestFolder.delete(true, null);
                }
                childDestFolder.create(true, true, null);
                WorkspaceManager.copyFilesInFolder((IContainer)childFolder, childDestFolder, extensions, monitor);
            }
            ++n;
        }
    }

    public static void copyFilesInFolder(String path, IFolder destFolder, String extension, boolean overWrite, IProgressMonitor monitor) throws CoreException, IOException {
        File[] files;
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            LOG.error((Object)("error to copy files. the input dir doesn't exist:" + path));
            return;
        }
        File[] fileArray = files = dir.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File f = fileArray[n];
            if (extension == null || f.getName().endsWith(extension)) {
                WorkspaceManager.copyFile(f.getAbsolutePath(), destFolder.getFile(f.getName()), overWrite, monitor);
            }
            ++n;
        }
    }

    public static void copyFile(IFile originalFile, IFolder destFolder, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = destFolder.getFile(originalFile.getName());
        if (file.exists()) {
            file.delete(true, monitor);
        }
        FileInputStream fs = new FileInputStream(originalFile.getRawLocation().toOSString());
        file.create((InputStream)fs, true, monitor);
        fs.close();
    }

    public static void copyFile(String filePath, IFile destFile, boolean overWrite, IProgressMonitor monitor) throws CoreException, IOException {
        if (!overWrite && destFile.exists()) {
            return;
        }
        if (destFile.exists()) {
            destFile.delete(true, monitor);
        }
        FileInputStream fs = new FileInputStream(filePath);
        destFile.create((InputStream)fs, true, null);
        fs.close();
    }

    public static IResource getSelectedResource() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IResource selResource = WorkspaceManager.getSelectedResource(page);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page) {
        IResource selResource = null;
        ISelection sel = page.getSelection();
        selResource = WorkspaceManager.getSelectedResource(page, sel);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page, ISelection sel) {
        IEditorPart editor;
        IEditorInput input;
        IResource selResource = null;
        if (sel instanceof StructuredSelection) {
            IAdaptable adaptable;
            StructuredSelection ssel = (StructuredSelection)sel;
            Object element = ssel.getFirstElement();
            if (element instanceof IResource) {
                selResource = (IResource)element;
            } else if (element instanceof IAdaptable && (selResource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) == null) {
                selResource = (IResource)page.getActiveEditor().getAdapter(IResource.class);
            }
        } else if (sel instanceof TextSelection && (input = (editor = page.getActiveEditor()).getEditorInput()) instanceof IFileEditorInput) {
            selResource = ((IFileEditorInput)input).getFile();
        }
        return selResource;
    }

    public static IFolder getFolderByPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getFolder(path);
    }

    public static IFile getFileByPath(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getFile(path);
    }

    public static void addProjectNature(IProject project, String natureID) throws CoreException {
        if (!project.hasNature(natureID)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureID;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    public static boolean isPerspectiveOpen(IWorkbench workBench, String pspId) {
        IPerspectiveDescriptor currentDescriptor;
        String activeId;
        IWorkbenchPage page;
        IWorkbenchWindow window = workBench.getActiveWorkbenchWindow();
        return window != null && (page = window.getActivePage()) != null && (activeId = (currentDescriptor = page.getPerspective()).getId()).equals(pspId);
    }

    public static void openPerspective(IWorkbench workBench, String pspId) {
        if (!WorkspaceManager.isPerspectiveOpen(workBench, pspId)) {
            IPerspectiveRegistry reg = workBench.getPerspectiveRegistry();
            IPerspectiveDescriptor pd = reg.findPerspectiveWithId(pspId);
            IWorkbenchWindow workbenchWin = workBench.getActiveWorkbenchWindow();
            IWorkbenchPage workbenchPage = workbenchWin.getActivePage();
            workbenchPage.setPerspective(pd);
        }
        LOG.debug((Object)("Workbench " + workBench + " changed to perspective: " + pspId));
    }

    public static IProject getProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getProject(projectName);
    }

    public static void addEntriesToClassPath(IJavaProject project, List<IClasspathEntry> newEntries) throws JavaModelException {
        IClasspathEntry[] existingEntries = project.getRawClasspath();
        int inx = 0;
        while (inx < existingEntries.length) {
            if (newEntries.contains(existingEntries[inx])) {
                while (newEntries.remove(existingEntries[inx])) {
                    LOG.info((Object)("remove duplicated classpatth entries '" + existingEntries[inx] + "' from the entries added to the project: " + project.getProject().getName()));
                }
            }
            ++inx;
        }
        IClasspathEntry[] concatenatedEntries = new IClasspathEntry[existingEntries.length + newEntries.size()];
        System.arraycopy(existingEntries, 0, concatenatedEntries, 0, existingEntries.length);
        int index = existingEntries.length;
        Iterator<IClasspathEntry> iter = newEntries.iterator();
        while (iter.hasNext()) {
            concatenatedEntries[index++] = iter.next();
        }
        project.setRawClasspath(concatenatedEntries, null);
    }

    public static void removeEntriesFromClassPath(IJavaProject jProject, String varName) throws JavaModelException {
        IClasspathEntry[] existingEntries = jProject.getRawClasspath();
        ArrayList<IClasspathEntry> cleanedEntries = new ArrayList<IClasspathEntry>(existingEntries.length);
        int inx = 0;
        while (inx < existingEntries.length) {
            if (existingEntries[inx].getPath().toOSString().indexOf(varName) == -1) {
                cleanedEntries.add(existingEntries[inx]);
            }
            ++inx;
        }
        jProject.setRawClasspath(cleanedEntries.toArray(new IClasspathEntry[cleanedEntries.size()]), null);
    }

    public static List<IClasspathEntry> convertFilesToPathEnries(List<IPath> libPaths, String pathVarName) throws JavaModelException {
        if (libPaths == null || libPaths.size() == 0) {
            return new ArrayList<IClasspathEntry>(0);
        }
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(libPaths.size());
        IPath rootPath = new Path(pathVarName).addTrailingSeparator();
        Iterator<IPath> iter = libPaths.iterator();
        while (iter.hasNext()) {
            entries.add(JavaCore.newLibraryEntry((IPath)((IPath)rootPath.clone()).append(iter.next()), null, null, (boolean)true));
        }
        return entries;
    }

    public static IEditorPart openEditor(IWorkbenchWindow window, IFile file) {
        return WorkspaceManager.openEditor(window, file, IDE.getDefaultEditor((IFile)file).getId());
    }

    public static IEditorPart openEditor(IWorkbenchWindow window, IFile file, String editorId) {
        IEditorPart editor = null;
        IWorkbenchPage page = window.getActivePage();
        try {
            if (page != null) {
                editor = editorId != null ? IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorId, (boolean)true) : IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return editor;
    }

    public static void setWorkspaceAutoBuild(boolean autoBuild) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = ws.getDescription();
        desc.setAutoBuilding(autoBuild);
        ws.setDescription(desc);
    }

    public static boolean getWorkspaceAutoBuild() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = ws.getDescription();
        return desc.isAutoBuilding();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuilderOrder {
        FIRST,
        LAST;

    }
}

