/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import java.util.List;
import javax.xml.ws.BindingType;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.stp.sc.common.annotations.ext.IAnnotationInitializer;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.tests.ScProjectBaseTest;
import org.eclipse.stp.sc.jaxws.utils.ext.JAXWSAnnotationInitializer;

public class JAXWSAnnotationInitializerTest
extends ScProjectBaseTest {
    private static final String PROJECT_NAME = "JAXWSAnnotationInitializerTestProject";
    protected String[] projectFiles = new String[]{"/src/com/iona/helloworld/HelloWorld.java"};
    protected String[] resourceFiles = new String[]{"/resources/HelloWorld.java_resource"};
    private CompilationUnit astRoot = null;
    private ICompilationUnit compilationUnit = null;
    private IAnnotationInitializer initializer = null;
    private IType jdtType = null;
    private IField jdtField = null;
    private IMethod jdtMethod = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.initializer = new JAXWSAnnotationInitializer();
        this.compilationUnit = JDTUtils.getJavaUnitFromFile((IFile)this.files[0]);
        this.astRoot = JDTUtils.getDomRootCompilationUnit((ICompilationUnit)JDTUtils.getJavaUnitFromFile((IFile)this.files[0]));
        this.jdtType = (IType)this.compilationUnit.getElementAt(34);
        this.jdtField = (IField)this.compilationUnit.getElementAt(62);
        this.jdtMethod = (IMethod)this.compilationUnit.getElementAt(103);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    public void testRequestWrapper() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(RequestWrapper.class, this.astRoot, (IMember)this.jdtMethod, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 3 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("className"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("localName"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(2)).getName().getIdentifier().equals("targetNamespace"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("com.iona.helloworld.SayHi"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(1)).getValue()).getLiteralValue().equals("sayHi"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(2)).getValue()).getLiteralValue().equals("http://helloworld.iona.com/"));
    }

    public void testResponseWrapper() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(ResponseWrapper.class, this.astRoot, (IMember)this.jdtMethod, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 3 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("className"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("localName"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(2)).getName().getIdentifier().equals("targetNamespace"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("com.iona.helloworld.SayHiResponse"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(1)).getValue()).getLiteralValue().equals("sayHiResponse"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(2)).getValue()).getLiteralValue().equals("http://helloworld.iona.com/"));
    }

    public void testServiceMode() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(ServiceMode.class, this.astRoot, (IMember)this.jdtType, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 1 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("value"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((QualifiedName)((MemberValuePair)mvpList.get(0)).getValue()).getFullyQualifiedName().equals("Service.Mode.PAYLOAD"));
    }

    public void testWebFault() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebFault.class, this.astRoot, (IMember)this.jdtType, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 3 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("faultBean"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("name"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(2)).getName().getIdentifier().equals("targetNamespace"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("com.iona.helloworld.HelloWorldFaultBean"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(1)).getValue()).getLiteralValue().equals("HelloWorldFault"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(2)).getValue()).getLiteralValue().equals("http://helloworld.iona.com/"));
    }

    public void testWebServiceClient() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebServiceClient.class, this.astRoot, (IMember)this.jdtType, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 3 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("name"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("targetNamespace"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(2)).getName().getIdentifier().equals("wsdlLocation"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("com.iona.helloworld.HelloWorld"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(1)).getValue()).getLiteralValue().equals("http://helloworld.iona.com/"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(2)).getValue()).getLiteralValue().equals("http://helloworld.iona.com/helloworld.wsdl"));
    }

    public void testWebEndpoint() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebEndpoint.class, this.astRoot, (IMember)this.jdtMethod, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 1 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("name"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("HelloWorldHTTPPort"));
    }

    public void testWebServiceProvider() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebServiceProvider.class, this.astRoot, (IMember)this.jdtType, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 4 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("portName"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("serviceName"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(2)).getName().getIdentifier().equals("targetNamespace"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(3)).getName().getIdentifier().equals("wsdlLocation"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("HelloWorldPort"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(1)).getValue()).getLiteralValue().equals("HelloWorldService"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(2)).getValue()).getLiteralValue().equals("http://helloworld.iona.com/"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(3)).getValue()).getLiteralValue().equals("http://helloworld.iona.com/helloworld.wsdl"));
    }

    public void testBindingType() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(BindingType.class, this.astRoot, (IMember)this.jdtType, null);
        JAXWSAnnotationInitializerTest.assertTrue((mvpList.size() == 1 ? 1 : 0) != 0);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("value"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("http://schemas.xmlsoap.org/wsdl/soap/http"));
    }

    public void testWebServiceRefType() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebServiceRef.class, this.astRoot, (IMember)this.jdtType, null);
        JAXWSAnnotationInitializerTest.assertEquals((int)mvpList.size(), (int)3);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("name"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("type"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(2)).getName().getIdentifier().equals("value"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("<specify name here>"));
    }

    public void testWebServiceRefField() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebServiceRef.class, this.astRoot, (IMember)this.jdtField, null);
        JAXWSAnnotationInitializerTest.assertEquals((int)mvpList.size(), (int)2);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("type"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("value"));
    }

    public void testWebServiceRefMethod() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebServiceRef.class, this.astRoot, (IMember)this.jdtMethod, null);
        JAXWSAnnotationInitializerTest.assertEquals((int)mvpList.size(), (int)3);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("name"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(1)).getName().getIdentifier().equals("type"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(2)).getName().getIdentifier().equals("value"));
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)((MemberValuePair)mvpList.get(0)).getValue()).getLiteralValue().equals("<specify name here>"));
    }

    public void testWebServiceRefs() throws Exception {
        List mvpList = this.initializer.getDefaultAttributes(WebServiceRefs.class, this.astRoot, (IMember)this.jdtType, null);
        JAXWSAnnotationInitializerTest.assertEquals((int)mvpList.size(), (int)1);
        JAXWSAnnotationInitializerTest.assertTrue((boolean)((MemberValuePair)mvpList.get(0)).getName().getIdentifier().equals("value"));
        ArrayInitializer arrayInit = (ArrayInitializer)((MemberValuePair)mvpList.get(0)).getValue();
        List expList = arrayInit.expressions();
        for (Object obj : expList) {
            NormalAnnotation anno = (NormalAnnotation)obj;
            List pairList = anno.values();
            MemberValuePair mvp = (MemberValuePair)pairList.get(0);
            JAXWSAnnotationInitializerTest.assertTrue((boolean)mvp.getName().getIdentifier().equals("name"));
            JAXWSAnnotationInitializerTest.assertTrue((boolean)((StringLiteral)mvp.getValue()).getLiteralValue().equals("<specify name here>"));
            mvp = (MemberValuePair)pairList.get(1);
            JAXWSAnnotationInitializerTest.assertTrue((boolean)mvp.getName().getIdentifier().equals("type"));
            mvp = (MemberValuePair)pairList.get(2);
            JAXWSAnnotationInitializerTest.assertTrue((boolean)mvp.getName().getIdentifier().equals("value"));
        }
    }
}

