/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.validator;

import junit.framework.TestCase;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.stp.sc.common.validator.AnnXMLTreeBuilder;
import org.eclipse.stp.sc.common.validator.XMLUtils;
import org.eclipse.stp.sc.jaxws.validator.TestUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnXmlTreeBuilderTest
extends TestCase {
    AnnXMLTreeBuilder builder;
    CompilationUnit astRoot = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = new AnnXMLTreeBuilder();
        ASTParser parser = ASTParser.newParser((int)3);
        String content = "";
        parser.setSource(content.toCharArray());
        this.astRoot = (CompilationUnit)parser.createAST(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBuildTreeFromOneAnnWS() throws Exception {
        NormalAnnotation wsAnn = TestUtils.createValidWSAnn(this.astRoot);
        Document doc = this.builder.buildTreeFromOneAnn(wsAnn);
        AnnXmlTreeBuilderTest.assertTrue((String)"should generate doc.", (doc != null ? 1 : 0) != 0);
        System.out.println("xml tree from ws ann:" + XMLUtils.getXMLAsString((Document)doc));
        Element ws = (Element)doc.getFirstChild();
        System.out.println("prefix:" + ws.getPrefix());
        System.out.println("local name:" + ws.getLocalName());
        System.out.println("name:" + ws.getNodeName());
        System.out.println("namespace uri:" + ws.getNamespaceURI());
        AnnXmlTreeBuilderTest.assertTrue((String)"should generate WebService.", (boolean)ws.getLocalName().equals("WebService"));
        AnnXmlTreeBuilderTest.assertTrue((String)"prefix should be tns", (boolean)ws.getPrefix().equals("tns"));
        AnnXmlTreeBuilderTest.assertTrue((String)"namespace should be http://jws/javax", (boolean)ws.getNamespaceURI().equals("http://jws/javax"));
    }

    public void testBuildTreeFromOneAnnSoap() throws Exception {
        NormalAnnotation wsAnn = TestUtils.createValidSOAPBindingAnn(this.astRoot);
        Document doc = this.builder.buildTreeFromOneAnn(wsAnn);
        AnnXmlTreeBuilderTest.assertTrue((String)"should generate doc.", (doc != null ? 1 : 0) != 0);
        System.out.println("xml tree from soap ann:" + XMLUtils.getXMLAsString((Document)doc));
        Element ws = (Element)doc.getFirstChild();
        AnnXmlTreeBuilderTest.assertTrue((String)"should generate SoapBinding.", (boolean)ws.getLocalName().equals("SOAPBinding"));
    }

    public void testBuildTreeFromSimpleName() throws Exception {
        NormalAnnotation wsAnn = TestUtils.createSimpleNameSOAPBindingAnn(this.astRoot);
        Document doc = this.builder.buildTreeFromOneAnn(wsAnn);
        AnnXmlTreeBuilderTest.assertTrue((String)"should generate doc.", (doc != null ? 1 : 0) != 0);
        System.out.println("xml tree from soap ann:" + XMLUtils.getXMLAsString((Document)doc));
        Element ws = (Element)doc.getFirstChild();
        AnnXmlTreeBuilderTest.assertTrue((String)"should generate SoapBinding.", (boolean)ws.getLocalName().equals("SOAPBinding"));
    }
}

