/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.views;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stp.sc.common.views.AnnotationView;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AnnotationViewTest
extends TestCase {
    private static final String ANNOTATION_VIEW_ID = "org.eclipse.stp.sc.common.views.AnnotationView";
    private static final String TEST_PROJECT_NAME = "AnnotationViewTestProject";
    private static final String LOCAL_JAVA = "src/MyWebService.java";
    private static final String JAVA_RESOURCE = "/resources/MyWebService.java_resource";
    IProject testProject;
    IJavaElement javaFile;
    IMember member;
    AnnotationView theView;
    IEditorPart theEditor;

    protected void setUp() throws Exception {
        this.testProject = TestUtilities.createTestCeltixProject(TEST_PROJECT_NAME);
        TestUtilities.setupJavaProject(this.testProject);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.theView = (AnnotationView)activeWorkbenchWindow.getActivePage().showView(ANNOTATION_VIEW_ID);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)JAVA_RESOURCE);
        this.theEditor = TestUtilities.openEditor((IWorkbenchWindow)activeWorkbenchWindow, (IFile)testFile);
        this.javaFile = JavaCore.create((IFile)testFile);
        AnnotationViewTest.assertTrue((boolean)(this.javaFile instanceof ICompilationUnit));
        IType[] types = ((ICompilationUnit)this.javaFile).getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i] instanceof IMember) {
                this.member = types[i];
                break;
            }
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.closeEditor(this.theEditor, false);
        this.theEditor = null;
        activePage.hideView((IViewPart)this.theView);
        this.theView = null;
        if (this.testProject != null && this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
    }

    public void testBasics() throws Exception {
        this.theView.workbenchSelectionListener.selectionChanged((IWorkbenchPart)this.theEditor, (ISelection)new TextSelection(22, 320));
        AnnotationViewTest.assertEquals((int)10, (int)this.theView.annotationsviewer.getTree().getItemCount());
        AnnotationViewTest.assertEquals((String)"Type : MyWebService --- MyWebService.java", (String)this.theView.getContentDescription());
        this.theView.workbenchSelectionListener.selectionChanged((IWorkbenchPart)this.theEditor, (ISelection)new TextSelection(60, 0));
        Thread.sleep(1000L, 0);
        AnnotationViewTest.assertEquals((int)9, (int)this.theView.annotationsviewer.getTree().getItemCount());
        AnnotationViewTest.assertEquals((String)"Method : hi --- MyWebService.java", (String)this.theView.getContentDescription());
    }

    public void testAnnotationAtTheTypeLevel() throws Exception {
        this.theView.workbenchSelectionListener.selectionChanged((IWorkbenchPart)this.theEditor, (ISelection)new TextSelection(33, 0));
        AnnotationViewTest.assertEquals((int)10, (int)this.theView.annotationsviewer.getTree().getItemCount());
        AnnotationViewTest.assertEquals((String)"Type : MyWebService --- MyWebService.java", (String)this.theView.getContentDescription());
        this.theView.workbenchSelectionListener.selectionChanged((IWorkbenchPart)this.theEditor, (ISelection)new TextSelection(60, 0));
        Thread.sleep(1000L, 0);
        AnnotationViewTest.assertEquals((int)9, (int)this.theView.annotationsviewer.getTree().getItemCount());
        AnnotationViewTest.assertEquals((String)"Method : hi --- MyWebService.java", (String)this.theView.getContentDescription());
    }
}

