/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.internal.wizards.RuntimeSelectionPage;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class WsdlFirstProjectWizardTest
extends TestCase {
    private static String TEST_PROJECT_NAME = "JAXWS-WSDLFirst-TestProject";
    WsdlFirstProjectWizard wizard;
    MyWizardDialog dialog;
    Button backButton;
    Button nextButton;
    Button finishButton;
    Button cancelButton;

    protected void setUp() throws Exception {
        TestUtilities.createTestRuntime();
        this.wizard = new WsdlFirstProjectWizard();
        this.wizard.init(PlatformUI.getWorkbench(), null);
        this.dialog = new MyWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.backButton = this.dialog.getTheButton(14);
        this.nextButton = this.dialog.getTheButton(15);
        this.finishButton = this.dialog.getTheButton(16);
        this.cancelButton = this.dialog.getTheButton(1);
    }

    protected void tearDown() throws Exception {
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        if (proj.exists()) {
            proj.delete(true, null);
        }
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    public void testAddPages() throws Exception {
        int count = this.wizard.getPageCount();
        WsdlFirstProjectWizardTest.assertEquals((String)"should have 4 pages", (int)4, (int)count);
    }

    public void testCreateWsdlFirstProjectOnly() throws Exception {
        WizardNewProjectCreationPage genPage = this.wizard.genPage;
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        RuntimeSelectionPage runtimePage = this.wizard.runtimePage;
        runtimePage.selectRuntimeByIndex(0);
        this.finishButton.notifyListeners(13, new Event());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WsdlFirstProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        WsdlFirstProjectWizardTest.assertTrue((String)"should have jax-ws nature", (boolean)proj.hasNature("org.eclipse.stp.sc.jaxws.nature"));
        WsdlFirstProjectWizardTest.assertFalse((String)"shouldn't have jaxb builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.jaxws.builders.jaxbbuilder"));
        WsdlFirstProjectWizardTest.assertFalse((String)"shouldn't hava j2w builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder"));
        WsdlFirstProjectWizardTest.assertTrue((String)"should has ann validatation builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.annvalidator"));
        String mode = proj.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
        WsdlFirstProjectWizardTest.assertNotNull((Object)mode);
        WsdlFirstProjectWizardTest.assertTrue((String)"should set to wsdl first mode.", (boolean)mode.equals("WSDLFrist"));
    }

    public void testCreateProjectWithWsdl() throws Exception {
        WizardNewProjectCreationPage genPage = this.wizard.genPage;
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        this.nextButton.notifyListeners(13, new Event());
        RuntimeSelectionPage runtimePage = this.wizard.runtimePage;
        runtimePage.selectRuntimeByIndex(0);
        this.nextButton.notifyListeners(13, new Event());
        String cxf_kit_location = System.getProperty("jaxws_kit_location");
        String wsdlPath = String.valueOf(cxf_kit_location) + File.separator + "samples" + File.separator + "hello_world" + File.separator + "wsdl" + File.separator + "hello_world.wsdl";
        this.wizard.wsdlPage.composite.txtFilePath.setText(wsdlPath);
        this.nextButton.notifyListeners(13, new Event());
        this.finishButton.notifyListeners(13, new Event());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WsdlFirstProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        IFile javaFile = proj.getFile("src/org/apache/hello_world_soap_http/Greeter.java");
        WsdlFirstProjectWizardTest.assertTrue((String)"should generate java code.", (boolean)javaFile.exists());
        IFile wsdlFile = proj.getFile("wsdl/hello_world.wsdl");
        WsdlFirstProjectWizardTest.assertTrue((String)"should generate wsdl file.", (boolean)wsdlFile.exists());
    }

    public void testCreateProjectWithoutCodeGeneration() throws Exception {
        WizardNewProjectCreationPage genPage = this.wizard.genPage;
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        this.nextButton.notifyListeners(13, new Event());
        RuntimeSelectionPage runtimePage = this.wizard.runtimePage;
        runtimePage.selectRuntimeByIndex(0);
        String cxf_kit_location = System.getProperty("jaxws_kit_location");
        String wsdlPath = String.valueOf(cxf_kit_location) + File.separator + "samples" + File.separator + "hello_world" + File.separator + "wsdl" + File.separator + "hello_world.wsdl";
        this.wizard.wsdlPage.composite.txtFilePath.setText(wsdlPath);
        WsdlFirstProjectWizardTest.assertTrue((String)"should check the code generation button.", (boolean)this.wizard.wsdlPage.composite.cbtGenCode.getSelection());
        this.wizard.wsdlPage.composite.cbtGenCode.setSelection(false);
        this.wizard.wsdlPage.composite.cbtGenCode.notifyListeners(13, new Event());
        WsdlFirstProjectWizardTest.assertTrue((String)"should disable next button.", (!this.nextButton.isEnabled() ? 1 : 0) != 0);
        this.finishButton.notifyListeners(13, new Event());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WsdlFirstProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        IFile javaFile = proj.getFile("src/org/apache/hello_world_soap_http/Greeter.java");
        WsdlFirstProjectWizardTest.assertTrue((String)"should not generate java code.", (!javaFile.exists() ? 1 : 0) != 0);
        IFile wsdlFile = proj.getFile("wsdl/hello_world.wsdl");
        WsdlFirstProjectWizardTest.assertTrue((String)"should generate wsdl file.", (boolean)wsdlFile.exists());
    }

    class MyWizardDialog
    extends WizardDialog {
        public MyWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        public Button getTheButton(int id) {
            return super.getButton(id);
        }
    }
}

