/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.wsdltojava;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.GeneralInfoPage;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.GenerateCodeWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GenerateCodeWizardTest
extends TestCase {
    private static final String TEST_PROJECT_NAME = "GenerateClientWizardTestProject";
    private static final String LOCAL_WSDL = "hello_world_RPCLit.wsdl";
    IProject testProject;
    GenerateCodeWizard wizard;
    WizardDialog dialog;
    GeneralInfoPage generalInfoPage;

    protected void setUp() throws Exception {
        this.testProject = TestUtilities.createTestCeltixProject(TEST_PROJECT_NAME);
        TestUtilities.setupJavaProject(this.testProject);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_WSDL, ((Object)((Object)this)).getClass(), (String)"/resources/hello_world_RPCLit.wsdl");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TestUtilities.openEditor((IWorkbenchWindow)window, (IFile)testFile);
        this.wizard = new GenerateCodeWizard(this.testProject, new StructuredSelection((Object[])new IFile[]{testFile}));
        this.dialog = new ScWizardDialog(window.getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.generalInfoPage = (GeneralInfoPage)this.wizard.getPage("generalPage");
    }

    protected void tearDown() throws Exception {
        this.closeDefaultWizard();
        if (this.testProject != null && this.testProject.exists()) {
            this.testProject.close(null);
            this.testProject.delete(true, null);
        }
    }

    protected void closeDefaultWizard() throws Exception {
        this.dialog.close();
        this.generalInfoPage = null;
        this.wizard = null;
    }

    public void testWizardNotNull() {
        GenerateCodeWizardTest.assertNotNull((Object)this.wizard);
    }

    public void testNumberWizardPages() {
        GenerateCodeWizardTest.assertEquals((int)1, (int)this.wizard.getPageCount());
    }

    public void testContextHelpID() {
    }

    public void testGeneralInfoPageIsStartingPage() {
        GenerateCodeWizardTest.assertEquals((Object)this.generalInfoPage, (Object)this.wizard.getStartingPage());
    }

    public void testNoPreviousPageInitially() {
        GenerateCodeWizardTest.assertNull((Object)this.wizard.getPreviousPage((IWizardPage)this.generalInfoPage));
    }

    public void testNoNextPageInitially() {
        GenerateCodeWizardTest.assertNull((Object)this.wizard.getNextPage((IWizardPage)this.generalInfoPage));
    }
}

