/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxwsri.test.utils;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.wst.server.core.IRuntime;

public final class TestUtilities
extends WorkbenchUtils {
    static String TEST_JAXWSRI_RUNTIME_ID = "test_jaxwsri_runtime";
    static String TEST_JAXWSRI_RUNTIME_TYPE = "org.eclipse.stp.soas.deploy.runtime.jaxwsri.212";

    private TestUtilities() {
    }

    public static void setupJavaProject(IProject project) throws Exception {
        TestUtilities.setupBasicJavaProject((IProject)project);
        if (!project.hasNature("org.eclipse.stp.sc.jaxws.nature")) {
            ScNature.addToProject((IProject)project, (String)"JavaFrist");
        }
    }

    public static void setupTestRuntimeInfo(IProject project) {
        String runtimeId = TestUtilities.createTestRuntime();
        RuntimeCore.setRuntimeID((IProject)project, (String)runtimeId);
        RuntimeCore.setRuntimeType((IProject)project, (String)TEST_JAXWSRI_RUNTIME_TYPE);
    }

    public static String createTestRuntime() {
        try {
            IRuntime runtime = RuntimeCore.getRuntime((String)TEST_JAXWSRI_RUNTIME_ID);
            String runtimeId = null;
            if (runtime == null) {
                String kitLocation = System.getProperty("jaxws_kit_location");
                Path kitPath = new Path(kitLocation);
                runtimeId = RuntimeCore.creatRuntime((String)TEST_JAXWSRI_RUNTIME_TYPE, (String)TEST_JAXWSRI_RUNTIME_ID, (IPath)kitPath);
            } else {
                runtimeId = runtime.getId();
            }
            return runtimeId;
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }

    public static IProject createTestJaxwsriProject(String projectName) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            newProject = TestUtilities.createProject((String)projectName, null);
        } else {
            try {
                newProject.open(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        TestUtilities.setupTestRuntimeInfo(newProject);
        return newProject;
    }

    public static IFile addFileResourceToTestProject(IProject project, String localFileName, Class testClass, String resourcePath) throws CoreException, IOException {
        TestUtilities.checkFolder((IProject)project, (String)localFileName);
        IFile newFile = project.getFile(localFileName);
        if (!newFile.exists()) {
            URL resourceWsdl = testClass.getResource(resourcePath);
            newFile.create(resourceWsdl.openStream(), true, null);
        }
        return newFile;
    }

    public static boolean hasBuilder(IProject project, String builderID) throws Exception {
        IProjectDescription des = project.getDescription();
        ICommand[] cmds = des.getBuildSpec();
        int i = 0;
        while (i < cmds.length) {
            if (cmds[i].getBuilderName().equals(builderID)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

