/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.sca.java.utils;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.sca.java.utils.JavaClassGenerator;
import org.eclipse.stp.sc.sca.java.utils.TestUtilities;

public class JavaClassGeneratorTest
extends TestCase {
    public static final String PACKAGE_NAME = "org.eclipse.stp.sc";
    public static final String CLASS_NAME = "JavaClassGeneratorTest";
    public static final String INTERFACE_NAME = "JavaInterfaceGeneratorTest";
    public static final String PROJECT_NAME = "JavaClassGeneratorTest";
    JavaClassGenerator generator;
    IProject project;

    protected void setUp() throws Exception {
        super.setUp();
        TestUtilities.createTestRuntime();
        this.project = WorkbenchUtils.createTestCeltixProject((String)"JavaClassGeneratorTest");
        WorkbenchUtils.setupBasicJavaProject((IProject)this.project);
        TestUtilities.setupTestRuntimeInfo((IProject)this.project);
        this.generator = new JavaClassGenerator();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.generator = null;
        this.project.delete(true, null);
    }

    public void testCreateJavaClass() throws Exception {
        this.generator.createJavaClass(PACKAGE_NAME, "JavaClassGeneratorTest", false, "SuperClass", this.project);
        IFile clsFile = this.project.getFile("/src/org/eclipse/stp/sc/JavaClassGeneratorTest.java");
        JavaClassGeneratorTest.assertTrue((String)"should generate cls file.", (boolean)clsFile.exists());
    }

    public void testCreateJavaInterface() throws Exception {
        this.generator.createJavaClass(PACKAGE_NAME, INTERFACE_NAME, true, null, this.project);
        IFile clsFile = this.project.getFile("/src/org/eclipse/stp/sc/JavaInterfaceGeneratorTest.java");
        JavaClassGeneratorTest.assertTrue((String)"should generate cls file.", (boolean)clsFile.exists());
    }
}

