/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.xmlvalidator.rule.engine;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleEngineTestBase;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleManager;

public class VRuleManagerTest
extends VRuleEngineTestBase {
    String PROJECT_NAME = "VRuleManagerTest";
    VRuleManager manager;

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = VRuleManager.getInstance();
    }

    protected String getProjectName() {
        return this.PROJECT_NAME;
    }

    public void testRulePath() throws Exception {
        VRuleManagerTest.assertEquals((int)this.manager.pathSet.size(), (int)2);
    }

    public void testLoadAllRulePaths() throws Exception {
        this.manager.loadRules();
        VRuleManagerTest.assertEquals((int)this.manager.ruleTable.size(), (int)5);
        VRuleManagerTest.assertEquals((int)this.manager.ruleSetTable.size(), (int)2);
        this.manager.removeRuleSet("SCA Validation Rule");
        VRuleManagerTest.assertEquals((int)this.manager.ruleSetTable.size(), (int)1);
    }

    public void testLoadRuleFromInputStream() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL ruleURL = new URL(baseURL + "/src/resources/SCA_VRules.xml");
        this.manager.loadRule(ruleURL.openStream());
        VRuleManagerTest.assertTrue((String)"should loaded sca rule", (boolean)this.manager.ruleTable.containsKey("sca_rule_oneway"));
    }
}

