/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.ModuleFile;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ServiceModuleDelegate
extends ProjectModule
implements IWebModule {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ServiceModuleDelegate.class);
    IPath ROOT = new Path("/");
    FilePackageOutputDescriptor fileDesc;
    IModule module;

    public ServiceModuleDelegate(IProject project, IPackageOutputDescriptor desc) {
        super(project);
        this.fileDesc = (FilePackageOutputDescriptor)desc;
    }

    public IModule[] getChildModules() {
        return null;
    }

    public IModuleResource[] members() throws CoreException {
        File file = this.fileDesc.getFile();
        String moduleName = file.getName();
        ModuleFile mFile = new ModuleFile(file, moduleName, this.ROOT.makeRelative());
        return new IModuleResource[]{mFile};
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public String getContextRoot() {
        String context = this.fileDesc.getFile().getName();
        if (context.lastIndexOf(".") > 0) {
            context = context.substring(0, context.lastIndexOf("."));
        }
        LOG.debug((Object)("getContextRoot return:" + context));
        return context;
    }

    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule[] getModules() {
        return new IModule[]{this.module};
    }

    public String getURI(IModule module) {
        LOG.debug((Object)("get url called for module:" + module));
        return this.fileDesc.getLogicalName();
    }

    public IContainer[] getJavaOutputFolders() {
        return null;
    }

    public IContainer[] getResourceFolders() {
        return null;
    }

    public boolean isBinary() {
        return true;
    }
}

