/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.AdapterFactoryContentProvider;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditorSectionPart;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PackagesSection
extends DeployEditorSectionPart
implements IPartSelectionListener {
    public static final String SECTION_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECTITLE.Packages");
    public static final String SECTION_DESC = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECDESC.Packages");
    private TableViewer mPackages;
    private boolean mProcessingSelectionChanged = false;

    public PackagesSection(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.getSection().setText(SECTION_TITLE);
        this.getSection().setDescription(SECTION_DESC);
    }

    public void createClient(FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)this.getSection());
        GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Table table = toolkit.createTable(container, 66304);
        this.mPackages = new TableViewer(table);
        GridData gd = new GridData(1808);
        gd.heightHint = table.getItemHeight() * 5;
        this.mPackages.getControl().setLayoutData((Object)gd);
        this.mPackages.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mPackages.setLabelProvider((IBaseLabelProvider)new PackagesLabelProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mPackages.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof DeployPackage;
            }
        });
        this.mPackages.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackagesSection.this.mProcessingSelectionChanged = true;
                try {
                    PackagesSection.this.fireSelectionChanged(event.getSelection());
                }
                finally {
                    PackagesSection.this.mProcessingSelectionChanged = false;
                }
            }
        });
        this.getSection().setClient((Control)container);
        toolkit.paintBordersFor(container);
    }

    protected void helpActivated(HyperlinkEvent event) {
        HelpUtilities.displayHelp((String)IHelpConstants.CONTEXT_ID_OVERVIEW_PAGE_PACKAGES_SECTION);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object obj;
        if (this.mProcessingSelectionChanged) {
            return;
        }
        if (!selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof DeployServer) {
            HashSet<DeployPackage> packages = new HashSet<DeployPackage>();
            Iterator it = ((DeployServer)obj).getTargetingConfiguration().iterator();
            while (it.hasNext()) {
                packages.add(((DeployConfiguration)it.next()).getSourcePackage());
            }
            this.mPackages.setSelection((ISelection)new StructuredSelection(packages.toArray()));
        }
    }

    protected void setModelRoot(EObject modelRoot) {
        if (!(modelRoot instanceof Root)) {
            throw new IllegalArgumentException("modelRoot must be of type " + Root.class);
        }
        this.mPackages.setInput((Object)((Root)modelRoot));
    }

    private static class PackagesLabelProvider
    extends AdapterFactoryLabelProvider {
        private ILabelProvider mWorkbenchLabelProvider = new WorkbenchLabelProvider();

        public PackagesLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return this.getImage(object);
        }

        public String getColumnText(Object object, int columnIndex) {
            return this.getText(object);
        }

        public Image getImage(Object element) {
            IPackage ip;
            Image image = null;
            this.adapterFactory.adapt(element, IItemLabelProvider.class);
            image = element instanceof DeployPackage ? ((ip = Utilities.adaptToIPackage((EObject)((DeployPackage)element))) == null ? super.getImage(element) : this.mWorkbenchLabelProvider.getImage((Object)ip.getFile())) : super.getImage(element);
            return image;
        }

        public String getText(Object element) {
            IPackage ip;
            this.adapterFactory.adapt(element, IItemLabelProvider.class);
            String text = element instanceof DeployPackage ? ((ip = Utilities.adaptToIPackage((EObject)((DeployPackage)element))) == null ? super.getText(element) : ip.getFile().getFullPath().toString()) : super.getText(element);
            return text;
        }

        public void dispose() {
            this.mWorkbenchLabelProvider.dispose();
            super.dispose();
        }
    }
}

