/*
 * Decompiled with CFR 0.152.
 */
package org.eclipes.stp.soas.deploy.runtime.jaxwsri.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.stp.common.logging.LoggingProxy;

public class RuntimeUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeUtils.class);

    public static String[] getLibEntryInManifest(String jarFileName) {
        File facadeFile = new File(jarFileName);
        ArrayList<String> libs = new ArrayList<String>();
        try {
            JarFile facadeJar = new JarFile(facadeFile);
            Manifest mfst = facadeJar.getManifest();
            Attributes attrs = mfst.getMainAttributes();
            String path = attrs.getValue("Class-Path");
            StringTokenizer tkzr = new StringTokenizer(path);
            String libEntry = null;
            while (tkzr.hasMoreTokens()) {
                libEntry = tkzr.nextToken();
                libs.add(libEntry);
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"Exception getting jar facade", (Throwable)e);
        }
        return libs.toArray(new String[0]);
    }

    public static String[] getLibEntryByDir(String path) {
        File dir = new File(path);
        ArrayList<String> libs = new ArrayList<String>();
        if (!dir.exists() || !dir.isDirectory()) {
            return new String[0];
        }
        String[] stringArray = dir.list();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fileName = stringArray[n];
            if (fileName.endsWith(".jar")) {
                libs.add(fileName);
            }
            ++n;
        }
        return libs.toArray(new String[0]);
    }
}

