/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.stp.ui.xef.editor.QNameFieldEditor;
import org.eclipse.ui.PlatformUI;

public class QNameFieldEditorTest
extends TestCase {
    QNameFieldEditor dialog;
    Map<String, String> namespaceMap;

    protected void setUp() throws Exception {
        this.namespaceMap = new HashMap<String, String>();
        this.namespaceMap.put("ns1", "http://www.example.com/test");
        this.namespaceMap.put("ns2", "http://www.example.com/foo");
        this.dialog = new QNameFieldEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.dialog.setFieldData(this.namespaceMap);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }

    protected void tearDown() throws Exception {
        this.dialog.close();
    }

    public void testDefaultSettings() throws Exception {
        QNameFieldEditorTest.assertEquals((String)"", (String)this.dialog.cboPrefix.getText());
        QNameFieldEditorTest.assertEquals((String)"", (String)this.dialog.txtNamespace.getText());
        QNameFieldEditorTest.assertEquals((String)"", (String)this.dialog.txtLocal.getText());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
    }

    public void testSettingFieldText() throws Exception {
        this.dialog.setFieldText("ns2:someLocalName");
        QNameFieldEditorTest.assertEquals((String)"ns2", (String)this.dialog.cboPrefix.getText());
        QNameFieldEditorTest.assertEquals((String)"someLocalName", (String)this.dialog.txtLocal.getText());
        QNameFieldEditorTest.assertEquals((String)"http://www.example.com/foo", (String)this.dialog.txtNamespace.getText());
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.setFieldText("ns3:nonExistantPrefix");
        QNameFieldEditorTest.assertEquals((String)"ns3", (String)this.dialog.cboPrefix.getText());
        QNameFieldEditorTest.assertEquals((String)"nonExistantPrefix", (String)this.dialog.txtLocal.getText());
        QNameFieldEditorTest.assertEquals((String)"", (String)this.dialog.txtNamespace.getText());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
    }

    public void testExistingPrefix() throws Exception {
        QNameFieldEditorTest.assertEquals((int)2, (int)this.dialog.cboPrefix.getItemCount());
        int i = 0;
        while (i < this.dialog.cboPrefix.getItems().length) {
            if ("ns2".equals(this.dialog.cboPrefix.getItem(i))) {
                this.dialog.cboPrefix.select(i);
            }
            ++i;
        }
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.txtNamespace.getText().equals(""));
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtLocal.setText("fooName");
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.okPressed();
        QNameFieldEditorTest.assertEquals((String)"ns2:fooName", (String)this.dialog.getFieldText());
    }

    public void testNewPrefix() throws Exception {
        this.dialog.cboPrefix.setText("junk");
        QNameFieldEditorTest.assertEquals((String)"", (String)this.dialog.txtNamespace.getText());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtNamespace.setText("http://www.example.com/new");
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtLocal.setText("testName");
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.okPressed();
        QNameFieldEditorTest.assertEquals((String)"junk:testName", (String)this.dialog.getFieldText());
    }

    public void testSelectPrefx() throws Exception {
        this.dialog.txtLocal.setText("someText");
        this.dialog.cboPrefix.setText("ns");
        QNameFieldEditorTest.assertEquals((String)"", (String)this.dialog.txtNamespace.getText());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.cboPrefix.setText("ns1");
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.txtNamespace.getText().equals(""));
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.cboPrefix.setText("ns12");
        QNameFieldEditorTest.assertEquals((String)"", (String)this.dialog.txtNamespace.getText());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtNamespace.setText("http://www.example.com/new");
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.cboPrefix.setText("ns123");
        QNameFieldEditorTest.assertEquals((String)"http://www.example.com/new", (String)this.dialog.txtNamespace.getText());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.okPressed();
        QNameFieldEditorTest.assertEquals((String)"ns123:someText", (String)this.dialog.getFieldText());
    }

    public void testInputOrder() throws Exception {
        this.dialog.txtLocal.setText("someText");
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtNamespace.setText("http://www.example.com/new");
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.cboPrefix.setText("test");
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.txtNamespace.getEditable());
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.cboPrefix.setText("");
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.cboPrefix.setText("test");
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtLocal.setText("");
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtLocal.setText("someText");
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtNamespace.setText("");
        QNameFieldEditorTest.assertFalse((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.txtNamespace.setText("http://www.example.com/new");
        QNameFieldEditorTest.assertTrue((boolean)this.dialog.btnOk.getEnabled());
        this.dialog.okPressed();
        QNameFieldEditorTest.assertEquals((String)"test:someText", (String)this.dialog.getFieldText());
    }
}

