/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IShadowProvider;
import org.eclipse.stp.xef.SchemaProviderFilterWrapper;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.util.InputStreamHelper;

public class SchemaProviderFilterWrapperTest
extends TestCase {
    private static final String AUDIT_SNIPPET = "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/>";
    private static final String TOP_SNIPPET = "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test_routing\"><Destination target_service=\"hahaha\"/></example:Routing>";
    private static final String SUPER_TOP_SNIPPET = "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test_routing\"><Destination target_service=\"hahaha\"/></example:Routing><example:secure xmlns:example=\"http://www.example.com/xsd/2006/02/test_secure3\"/>";
    private static final String UNRELATED_SNIPPET = "<example:secure xmlns:example=\"http://www.example.com/xsd/2006/02/test_secure\"/><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test_routing\"><Destination target_service=\"hahaha\"/></example:Routing>";
    private static final String SOME_OTHER_SNIPPET = "<example:secure xmlns:example=\"http://www.example.com/xsd/2006/02/test_secure\"/>";
    private static final String IMPORTING_SNIPPET = "<example:TestImporter2 xmlns:example='http://www.example.com/test_importer_2'/>";
    private static final String COMPRESSION_SNIPPET = "<example:compression xmlns:example=\"http://www.example.com/xsd/2007/02/test_compression\"/>";
    private static final String SOAP_HTTP_COMPRESSION_SNIPPET = "<example:compression xmlns:example=\"http://www.example.com/xsd/2007/02/test_compression\"/><example:soap xmlns:example=\"http://www.example.com/xsd/2007/02/test_soap\"/><example:http xmlns:example=\"http://www.example.com/xsd/2007/02/test_http\"/>";
    private static final String SOAP_HTTPS_SNIPPET = "<example:https xmlns:example=\"http://www.example.com/xsd/2007/02/test_https\"/><example:soap xmlns:example=\"http://www.example.com/xsd/2007/02/test_soap\"/><example:http xmlns:example=\"http://www.example.com/xsd/2007/02/test_http\"/>";
    private static final String HTTPS_SNIPPET = "<example:https xmlns:example=\"http://www.example.com/xsd/2007/02/test_https\"/>";
    private static final String HTTP_HTTPS_SNIPPET = "<example:http xmlns:example=\"http://www.example.com/xsd/2007/02/test_http\"/><example:https xmlns:example=\"http://www.example.com/xsd/2007/02/test_https\"/>";
    private static final String DEPA_DEPB_SNIPPET = "<example:depa xmlns:example=\"http://www.example.com/xsd/2007/02/test_depa\"/><example:depb xmlns:example=\"http://www.example.com/xsd/2007/02/test_depb\"/>";

    protected void setUp() throws Exception {
        SchemaRegistry.getDefault().clear();
    }

    protected void tearDown() throws Exception {
        SchemaRegistry.getDefault().clear();
    }

    public void testSchemaProviderFilterWrapperNoFiltering() throws Exception {
        TestSchemaProvider tsp = this.getSchemaProvider();
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, new ArrayList());
        SchemaProviderFilterWrapperTest.assertEquals((int)6, (int)wsp.listSchemaNamespaces(null).size());
        SchemaProviderFilterWrapperTest.assertEquals((String)SchemaProviderFilterWrapperTest.loadSchema("example_test.xsd"), (String)wsp.getSchema("http://www.example.com/xsd/2006/02/test"));
        SchemaProviderFilterWrapperTest.assertEquals((String)SchemaProviderFilterWrapperTest.loadSchema("example_test_audit.xsd"), (String)wsp.getSchema("http://www.example.com/xsd/2006/02/test_audit"));
        SchemaProviderFilterWrapperTest.assertEquals((String)SchemaProviderFilterWrapperTest.loadSchema("example_test_reliable.xsd"), (String)wsp.getSchema("http://www.example.com/xsd/2006/02/test_reliable"));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)wsp.listSnippets(null).size());
        SchemaProviderFilterWrapperTest.assertEquals((String)AUDIT_SNIPPET, (String)wsp.getSnippet("Audit Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)TOP_SNIPPET, (String)wsp.getSnippet("Top Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)UNRELATED_SNIPPET, (String)wsp.getSnippet("Unrelated"));
    }

    public void testSchemaProviderFilterWrapperFiltering() throws Exception {
        String auditNS = "http://www.example.com/xsd/2006/02/test_audit";
        TestSchemaProvider tsp = this.getSchemaProvider();
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(auditNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        ArrayList namespaces = new ArrayList(wsp.listSchemaNamespaces(null));
        SchemaProviderFilterWrapperTest.assertEquals((int)5, (int)namespaces.size());
        SchemaProviderFilterWrapperTest.assertTrue((boolean)namespaces.contains("http://www.example.com/xsd/2006/02/test_reliable"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)namespaces.contains("http://www.example.com/xsd/2006/02/test"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)namespaces.contains("http://www.example.com/xsd/2006/02/test_secure3"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)namespaces.contains("http://www.example.com/test_importer_2"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)namespaces.contains("http://www.example.com/test_importee_2"));
        SchemaProviderFilterWrapperTest.assertEquals((String)SchemaProviderFilterWrapperTest.loadSchema("example_test.xsd"), (String)wsp.getSchema("http://www.example.com/xsd/2006/02/test"));
        SchemaProviderFilterWrapperTest.assertNull((Object)wsp.getSchema("http://www.example.com/xsd/2006/02/test_audit"));
        SchemaProviderFilterWrapperTest.assertEquals((String)SchemaProviderFilterWrapperTest.loadSchema("example_test_reliable.xsd"), (String)wsp.getSchema("http://www.example.com/xsd/2006/02/test_reliable"));
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)wsp.listSnippets(null).size());
        SchemaProviderFilterWrapperTest.assertEquals((String)"Unrelated", (String)((String)wsp.listSnippets(null).iterator().next()));
        SchemaProviderFilterWrapperTest.assertNull((Object)wsp.getSnippet("Audit Snippet"));
        SchemaProviderFilterWrapperTest.assertNull((Object)wsp.getSnippet("Top Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)UNRELATED_SNIPPET, (String)wsp.getSnippet("Unrelated"));
    }

    public void testRefresh() throws Exception {
        TestSchemaProvider tsp = this.getSchemaProvider();
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, new ArrayList());
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)wsp.listSnippets(null).size());
        tsp.snippets.put("Some Other Snippet", SOME_OTHER_SNIPPET);
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)wsp.listSnippets(null).size());
        wsp.refresh();
        SchemaProviderFilterWrapperTest.assertEquals((int)4, (int)wsp.listSnippets(null).size());
    }

    public void testShadowProvider() throws Exception {
        TestSchemaProvider tsp = this.getSchemaProvider();
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema("http://www.example.com/xsd/2006/02/test_audit"), false, new ISchemaProvider[0]).get(0);
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema("http://www.example.com/xsd/2006/02/test_reliable"), false, new ISchemaProvider[0]).get(0);
        SchemaElement se2 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema("http://www.example.com/xsd/2006/02/test_secure3"), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        filters.add(new XMLInstanceElement(se1));
        filters.add(new XMLInstanceElement(se2));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        IShadowProvider shp = wsp.getShadowProvider();
        List<String> cats = Arrays.asList(shp.getShadowCategories());
        SchemaProviderFilterWrapperTest.assertEquals((String)"Security", (String)cats.get(0));
        SchemaProviderFilterWrapperTest.assertEquals((String)"Uncategorized", (String)cats.get(1));
        SchemaProviderFilterWrapperTest.assertEquals((int)2, (int)cats.size());
        List<Object> secSchemas = Arrays.asList(shp.getShadowed(cats.get(0)));
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)secSchemas.size());
        SchemaElement el = (SchemaElement)secSchemas.get(0);
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:security", (String)el.getDisplayName());
        SchemaProviderFilterWrapperTest.assertEquals((String)"already applied", (String)shp.getReason((Object)el));
        HashMap<String, SchemaElement> otherSchemas = new HashMap<String, SchemaElement>();
        Object[] objectArray = shp.getShadowed(cats.get(1));
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object obj = objectArray[n];
            SchemaElement sel = (SchemaElement)obj;
            otherSchemas.put(sel.getDisplayName(), sel);
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertEquals((String)"already applied", (String)shp.getReason(otherSchemas.get("example:audit")));
        SchemaProviderFilterWrapperTest.assertEquals((String)"already applied", (String)shp.getReason(otherSchemas.get("example:Reliable")));
        SchemaProviderFilterWrapperTest.assertEquals((int)2, (int)otherSchemas.size());
    }

    public void testShadowProviderWithImports() throws Exception {
        TestSchemaProvider tsp = this.getSchemaProvider();
        tsp.snippets.put("Importer", IMPORTING_SNIPPET);
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema("http://www.example.com/test_importer_2"), false, new ISchemaProvider[]{tsp}).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        IShadowProvider shp = wsp.getShadowProvider();
        String[] cats = shp.getShadowCategories();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)cats.length);
        SchemaProviderFilterWrapperTest.assertEquals((String)"Uncategorized", (String)cats[0]);
        Object[] shadowed = shp.getShadowed(cats[0]);
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)shadowed.length);
        SchemaElement testImporter2 = (SchemaElement)shadowed[0];
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:TestImporter2", (String)testImporter2.getDisplayName());
        List subels = testImporter2.getMinimalSubElementList();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)subels.size());
        SchemaProviderFilterWrapperTest.assertEquals((String)"wibble", (String)((SchemaElement)subels.get(0)).getDisplayName());
    }

    public void testShadowProviderForSnippets() throws Exception {
        String auditNS = "http://www.example.com/xsd/2006/02/test_audit";
        String securityNS = "http://www.example.com/xsd/2006/02/test_secure3";
        TestSchemaProvider tsp = this.getSchemaProvider();
        tsp.snippets.put("Super Top Snippet", SUPER_TOP_SNIPPET);
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(auditNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaElement se2 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(securityNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se2));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        IShadowProvider shp = wsp.getShadowProvider();
        List<Object> shadowed = Arrays.asList(shp.getShadowed("Composite Policies"));
        List<String> cats = Arrays.asList(shp.getShadowCategories());
        SchemaProviderFilterWrapperTest.assertTrue((boolean)cats.contains("Composite Policies"));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed.size());
        int auditIdx = shadowed.indexOf("Audit Snippet");
        SchemaProviderFilterWrapperTest.assertTrue((auditIdx >= 0 ? 1 : 0) != 0);
        int topIdx = shadowed.indexOf("Top Snippet");
        SchemaProviderFilterWrapperTest.assertTrue((topIdx >= 0 ? 1 : 0) != 0);
        int superTopIdx = shadowed.indexOf("Super Top Snippet");
        SchemaProviderFilterWrapperTest.assertTrue((superTopIdx >= 0 ? 1 : 0) != 0);
        String auditReason = shp.getReason(shadowed.get(auditIdx));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:audit already applied", (String)auditReason);
        String topReason = shp.getReason(shadowed.get(topIdx));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:audit already applied", (String)topReason);
        String superTopReason = shp.getReason(shadowed.get(superTopIdx));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:audit, example:security already applied", (String)superTopReason);
    }

    public void testShadowProviderSnippetsWithImports() throws Exception {
        TestSchemaProvider tsp = this.getSchemaProvider();
        tsp.snippets.put("Importer", IMPORTING_SNIPPET);
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema("http://www.example.com/test_importer_2"), false, new ISchemaProvider[]{tsp}).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        IShadowProvider shp = wsp.getShadowProvider();
        String[] cats = shp.getShadowCategories();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)cats.length);
        SchemaProviderFilterWrapperTest.assertEquals((String)"Uncategorized", (String)cats[0]);
        SchemaRegistry.getDefault().clear();
        Object[] snippets = shp.getShadowed("Composite Policies");
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)snippets.length);
        SchemaProviderFilterWrapperTest.assertEquals((String)"Importer", (String)snippets[0].toString());
        List elements = SchemaRegistry.getDefault().getEntryElements("http://www.example.com/test_importer_2", false, true, new ISchemaProvider[0]);
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)elements.size());
        SchemaElement el = (SchemaElement)elements.get(0);
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:TestImporter2", (String)el.getDisplayName());
        List subEls = el.getMinimalSubElementList();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)subEls.size());
        SchemaProviderFilterWrapperTest.assertEquals((String)"wibble", (String)((SchemaElement)subEls.get(0)).getDisplayName());
    }

    public void testQuantifiers() throws Exception {
        String soapNS = "http://www.example.com/xsd/2007/02/test_soap";
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addSchemas2(tsp);
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(soapNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        ArrayList namespaces = new ArrayList(wsp.listSchemaNamespaces(null));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)namespaces.contains("http://www.example.com/xsd/2007/02/test_http"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)namespaces.contains("http://www.example.com/xsd/2007/02/test_compression"));
        SchemaProviderFilterWrapperTest.assertEquals((int)2, (int)namespaces.size());
        IShadowProvider shp = wsp.getShadowProvider();
        String[] cats = shp.getShadowCategories();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)cats.length);
        Object[] shadowed = shp.getShadowed(cats[0]);
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed.length);
        boolean corbaChecked = false;
        boolean soapChecked = false;
        Object[] objectArray = shadowed;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object s = objectArray[n];
            if (s instanceof SchemaElement) {
                String reason;
                SchemaElement e = (SchemaElement)s;
                if ("http://www.example.com/xsd/2007/05/test_corba".equals(e.getNameSpace())) {
                    reason = shp.getReason(s);
                    SchemaProviderFilterWrapperTest.assertEquals((String)"Soap policy already applied", (String)reason);
                    corbaChecked = true;
                } else if ("http://www.example.com/xsd/2007/02/test_soap".equals(e.getNameSpace())) {
                    reason = shp.getReason(s);
                    SchemaProviderFilterWrapperTest.assertEquals((String)SchemaProviderFilterWrapper.DisallowanceReason.ALREADY_APPLIED.toString(), (String)reason);
                    soapChecked = true;
                } else {
                    "http://www.example.com/xsd/2007/02/test_https".equals(e.getNameSpace());
                }
            }
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)corbaChecked);
        SchemaProviderFilterWrapperTest.assertTrue((boolean)soapChecked);
    }

    public void testQuantifiersWithSnippets() throws Exception {
        String corbaNS = "http://www.example.com/xsd/2007/05/test_corba";
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addSchemas2(tsp);
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(corbaNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        Collection snippets = wsp.listSnippets(null);
        SchemaProviderFilterWrapperTest.assertTrue((boolean)snippets.contains("Compression Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)snippets.contains("HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)snippets.contains("Unrelated"));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)snippets.size());
        IShadowProvider shp = wsp.getShadowProvider();
        HashMap<String, Object> shadowed = new HashMap<String, Object>();
        Object[] objectArray = shp.getShadowed("Composite Policies");
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            shadowed.put(o.toString(), o);
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("Soap HTTP Compr Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("Soap over HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("HTTP+HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed.size());
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:corba already applied", (String)shp.getReason(shadowed.get("Soap HTTP Compr Snippet")));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:corba already applied", (String)shp.getReason(shadowed.get("Soap over HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:corba already applied", (String)shp.getReason(shadowed.get("HTTP+HTTPs Snippet")));
    }

    public void testQuantifiersWithSnippets2() throws Exception {
        String soapNS = "http://www.example.com/xsd/2007/02/test_soap";
        String httpNS = "http://www.example.com/xsd/2007/02/test_http";
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addSchemas2(tsp);
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(soapNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaElement se2 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(httpNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se2));
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        Collection snippets = wsp.listSnippets(null);
        SchemaProviderFilterWrapperTest.assertTrue((boolean)snippets.contains("Compression Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)snippets.contains("HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)snippets.contains("Unrelated"));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)snippets.size());
        IShadowProvider shp = wsp.getShadowProvider();
        HashMap<String, Object> shadowed = new HashMap<String, Object>();
        Object[] objectArray = shp.getShadowed("Composite Policies");
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            shadowed.put(o.toString(), o);
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("Soap HTTP Compr Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("Soap over HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("HTTP+HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed.size());
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http, Soap policy already applied", (String)shp.getReason(shadowed.get("Soap HTTP Compr Snippet")));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http, Soap policy already applied", (String)shp.getReason(shadowed.get("Soap over HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http already applied", (String)shp.getReason(shadowed.get("HTTP+HTTPs Snippet")));
    }

    public void testRequires() throws Exception {
        String soapNS = "http://www.example.com/xsd/2007/02/test_soap";
        String httpNS = "http://www.example.com/xsd/2007/02/test_http";
        String httpsNS = "http://www.example.com/xsd/2007/02/test_https";
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addSchemas2(tsp);
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, new ArrayList());
        SchemaProviderFilterWrapperTest.assertFalse((boolean)wsp.listSchemaNamespaces(null).contains(httpsNS));
        IShadowProvider shp = wsp.getShadowProvider();
        String[] cats = shp.getShadowCategories();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)cats.length);
        Object[] shadowed = shp.getShadowed(cats[0]);
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)shadowed.length);
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:https", (String)shadowed[0].toString());
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http, Soap policy and/or example:corba required", (String)shp.getReason(shadowed[0]));
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(httpNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp2 = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        SchemaProviderFilterWrapperTest.assertFalse((boolean)wsp2.listSchemaNamespaces(null).contains(httpsNS));
        IShadowProvider shp2 = wsp2.getShadowProvider();
        String[] cats2 = shp2.getShadowCategories();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)cats2.length);
        HashMap<String, Object> shadowed2 = new HashMap<String, Object>();
        Object[] objectArray = shp2.getShadowed(cats2[0]);
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            shadowed2.put(o.toString(), o);
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed2.size());
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed2.containsKey("example:https"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed2.containsKey("example:http"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed2.containsKey("example:corba"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"Soap policy and/or example:corba required", (String)shp2.getReason(shadowed2.get("example:https")));
        SchemaElement se2 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(soapNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se2));
        SchemaProviderFilterWrapper wsp3 = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        IShadowProvider shp3 = wsp3.getShadowProvider();
        SchemaProviderFilterWrapperTest.assertTrue((boolean)wsp3.listSchemaNamespaces(null).contains(httpsNS));
        String[] cats3 = shp3.getShadowCategories();
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)cats3.length);
        ArrayList<String> shadowed3 = new ArrayList<String>();
        Object[] objectArray2 = shp3.getShadowed(cats3[0]);
        int n3 = 0;
        int n4 = objectArray2.length;
        while (n3 < n4) {
            Object o = objectArray2[n3];
            shadowed3.add(o.toString());
            ++n3;
        }
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed3.size());
        SchemaProviderFilterWrapperTest.assertFalse((boolean)shadowed3.contains("example:https"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed3.contains("example:http"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed3.contains("example:corba"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed3.contains("Soap policy"));
    }

    public void testRequiresWithSnippets() throws Exception {
        String soapNS = "http://www.example.com/xsd/2007/02/test_soap";
        String httpNS = "http://www.example.com/xsd/2007/02/test_http";
        String httpsNS = "http://www.example.com/xsd/2007/02/test_https";
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addSchemas2(tsp);
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, new ArrayList());
        SchemaProviderFilterWrapperTest.assertFalse((boolean)wsp.listSchemaNamespaces(null).contains(httpsNS));
        IShadowProvider shp = wsp.getShadowProvider();
        HashMap<String, Object> shadowed = new HashMap<String, Object>();
        Object[] objectArray = shp.getShadowed("Composite Policies");
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            shadowed.put(o.toString(), o);
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http, Soap policy and/or example:corba required", (String)shp.getReason(shadowed.get("HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("HTTP+HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"Soap policy and/or example:corba required", (String)shp.getReason(shadowed.get("HTTP+HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertEquals((int)2, (int)shadowed.size());
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(soapNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp2 = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        SchemaProviderFilterWrapperTest.assertFalse((boolean)wsp2.listSchemaNamespaces(null).contains(httpsNS));
        IShadowProvider shp2 = wsp2.getShadowProvider();
        HashMap<String, Object> shadowed2 = new HashMap<String, Object>();
        Object[] objectArray2 = shp2.getShadowed("Composite Policies");
        int n3 = 0;
        int n4 = objectArray2.length;
        while (n3 < n4) {
            Object o = objectArray2[n3];
            shadowed2.put(o.toString(), o);
            ++n3;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed2.containsKey("HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http and/or example:corba required", (String)shp2.getReason(shadowed2.get("HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed2.containsKey("Soap over HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"Soap policy already applied", (String)shp2.getReason(shadowed2.get("Soap over HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed2.containsKey("Soap HTTP Compr Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"Soap policy already applied", (String)shp2.getReason(shadowed2.get("Soap HTTP Compr Snippet")));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed2.size());
        SchemaElement se2 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(httpNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se2));
        SchemaProviderFilterWrapper wsp3 = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        IShadowProvider shp3 = wsp3.getShadowProvider();
        HashMap<String, Object> shadowed3 = new HashMap<String, Object>();
        Object[] objectArray3 = shp3.getShadowed("Composite Policies");
        int n5 = 0;
        int n6 = objectArray3.length;
        while (n5 < n6) {
            Object o = objectArray3[n5];
            shadowed3.put(o.toString(), o);
            ++n5;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed3.containsKey("Soap over HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http, Soap policy already applied", (String)shp3.getReason(shadowed3.get("Soap over HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed3.containsKey("Soap HTTP Compr Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http, Soap policy already applied", (String)shp3.getReason(shadowed3.get("Soap HTTP Compr Snippet")));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed3.containsKey("HTTP+HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"example:http already applied", (String)shp3.getReason(shadowed3.get("HTTP+HTTPs Snippet")));
        SchemaProviderFilterWrapperTest.assertEquals((int)3, (int)shadowed3.size());
    }

    public void testRequiresSnippetsWithRequiredAndProhibitedCombinedReasons() throws Exception {
        String httpNS = "http://www.example.com/xsd/2007/02/test_http";
        String httpsNS = "http://www.example.com/xsd/2007/02/test_https";
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addSchemas2(tsp);
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, new ArrayList());
        SchemaProviderFilterWrapperTest.assertFalse((boolean)wsp.listSchemaNamespaces(null).contains(httpsNS));
        IShadowProvider shp = wsp.getShadowProvider();
        HashMap<String, Object> shadowed = new HashMap<String, Object>();
        Object[] objectArray = shp.getShadowed("Composite Policies");
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            shadowed.put(o.toString(), o);
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("HTTP+HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"Soap policy and/or example:corba required", (String)shp.getReason(shadowed.get("HTTP+HTTPs Snippet")));
        ArrayList<XMLInstanceElement> filters = new ArrayList<XMLInstanceElement>();
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromXML(tsp.getSchema(httpNS), false, new ISchemaProvider[0]).get(0);
        filters.add(new XMLInstanceElement(se));
        SchemaProviderFilterWrapper wsp2 = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, filters);
        SchemaProviderFilterWrapperTest.assertFalse((boolean)wsp2.listSchemaNamespaces(null).contains(httpsNS));
        IShadowProvider shp2 = wsp2.getShadowProvider();
        HashMap<String, Object> shadowed2 = new HashMap<String, Object>();
        Object[] objectArray2 = shp2.getShadowed("Composite Policies");
        int n3 = 0;
        int n4 = objectArray2.length;
        while (n3 < n4) {
            Object o = objectArray2[n3];
            shadowed2.put(o.toString(), o);
            ++n3;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed2.containsKey("HTTP+HTTPs Snippet"));
        SchemaProviderFilterWrapperTest.assertEquals((String)"Even though the soap policy still isn't applied, the snippet can now *also* not be applied because the http policy is already applied. This 'already applied' violation takes precedence and therefore is the only violation mentioned at this point.", (String)"example:http already applied", (String)shp2.getReason(shadowed2.get("HTTP+HTTPs Snippet")));
    }

    public void testBidirectionDependentSchemaSnippet() throws Exception {
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addSchemas3(tsp);
        SchemaProviderFilterWrapper wsp = new SchemaProviderFilterWrapper((ISchemaProvider)tsp, new ArrayList());
        SchemaProviderFilterWrapperTest.assertEquals((String)"No schemas should be available directly", (int)0, (int)wsp.listSchemaNamespaces(null).size());
        IShadowProvider shp = wsp.getShadowProvider();
        HashMap<String, Object> shadowed = new HashMap<String, Object>();
        Object[] objectArray = shp.getShadowed("Uncategorized");
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object o = objectArray[n];
            shadowed.put(o.toString(), o);
            ++n;
        }
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("example:depa"));
        SchemaProviderFilterWrapperTest.assertTrue((boolean)shadowed.containsKey("example:depb"));
        SchemaProviderFilterWrapperTest.assertEquals((int)2, (int)shadowed.size());
        Collection snippets = wsp.listSnippets(null);
        SchemaProviderFilterWrapperTest.assertEquals((int)1, (int)snippets.size());
        SchemaProviderFilterWrapperTest.assertEquals((String)"Bidir Dep", (String)((String)snippets.iterator().next()));
        SchemaProviderFilterWrapperTest.assertEquals((int)0, (int)shp.getShadowed("Composite Policies").length);
    }

    private TestSchemaProvider getSchemaProvider() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        this.addSchemas1(sp);
        return sp;
    }

    private void addSchemas1(TestSchemaProvider sp) throws Exception {
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_reliable", SchemaProviderFilterWrapperTest.loadSchema("example_test_reliable.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test", SchemaProviderFilterWrapperTest.loadSchema("example_test.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaProviderFilterWrapperTest.loadSchema("example_test_audit.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_secure3", SchemaProviderFilterWrapperTest.loadSchema("example_test_secure3.xsd"));
        sp.schemas.put("http://www.example.com/test_importer_2", SchemaProviderFilterWrapperTest.loadSchema("example_test_importer_2.xsd"));
        sp.schemas.put("http://www.example.com/test_importee_2", SchemaProviderFilterWrapperTest.loadSchema("example_test_importee_2.xsd"));
        sp.snippets.put("Top Snippet", TOP_SNIPPET);
        sp.snippets.put("Audit Snippet", AUDIT_SNIPPET);
        sp.snippets.put("Unrelated", UNRELATED_SNIPPET);
    }

    private void addSchemas2(TestSchemaProvider sp) throws Exception {
        sp.schemas.put("http://www.example.com/xsd/2007/05/test_corba", SchemaProviderFilterWrapperTest.loadSchema("example_test_corba.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2007/02/test_soap", SchemaProviderFilterWrapperTest.loadSchema("example_test_soap.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2007/02/test_http", SchemaProviderFilterWrapperTest.loadSchema("example_test_http.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2007/02/test_https", SchemaProviderFilterWrapperTest.loadSchema("example_test_https.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2007/02/test_compression", SchemaProviderFilterWrapperTest.loadSchema("example_test_compression.xsd"));
        sp.snippets.put("Compression Snippet", COMPRESSION_SNIPPET);
        sp.snippets.put("Soap HTTP Compr Snippet", SOAP_HTTP_COMPRESSION_SNIPPET);
        sp.snippets.put("Soap over HTTPs Snippet", SOAP_HTTPS_SNIPPET);
        sp.snippets.put("HTTP+HTTPs Snippet", HTTP_HTTPS_SNIPPET);
        sp.snippets.put("HTTPs Snippet", HTTPS_SNIPPET);
        sp.snippets.put("Unrelated", UNRELATED_SNIPPET);
    }

    private void addSchemas3(TestSchemaProvider sp) throws Exception {
        sp.schemas.put("http://www.example.com/xsd/2007/02/test_depa", SchemaProviderFilterWrapperTest.loadSchema("example_test_depa.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2007/02/test_depb", SchemaProviderFilterWrapperTest.loadSchema("example_test_depb.xsd"));
        sp.snippets.put("Bidir Dep", DEPA_DEPB_SNIPPET);
    }

    private static String loadSchema(String name) throws IOException {
        InputStream is = SchemaProviderFilterWrapperTest.class.getClassLoader().getResource("/" + name).openStream();
        try {
            String string = new String(InputStreamHelper.drain((InputStream)is));
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestSchemaProvider
    implements ISchemaProvider {
        protected Map<String, String> schemas = new LinkedHashMap<String, String>();
        protected Map<String, String> snippets = new LinkedHashMap<String, String>();

        private TestSchemaProvider() {
        }

        public String getSchema(String qname) {
            return this.schemas.get(qname);
        }

        public String getSnippet(String name) {
            return this.snippets.get(name);
        }

        public Collection<String> listSchemaNamespaces(String filter) {
            return this.schemas.keySet();
        }

        public Collection<String> listSnippets(String filter) {
            return this.snippets.keySet();
        }

        public void refresh() {
        }
    }
}

