/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import junit.framework.TestCase;
import org.eclipse.stp.xef.XMLUtil;
import org.eclipse.stp.xef.util.FileTreeList;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtilTest
extends TestCase {
    private static final String LF = "\n";
    private File tempdir;

    protected void setUp() throws Exception {
        this.tempdir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/tmp" + System.currentTimeMillis());
        this.tempdir.mkdirs();
    }

    protected void tearDown() throws Exception {
        FileTreeList ftl = new FileTreeList(this.tempdir);
        Enumeration e = ftl.getFiles();
        while (e.hasMoreElements()) {
            File f = (File)e.nextElement();
            XMLUtilTest.assertTrue((boolean)f.delete());
        }
    }

    public void testXMLSnippet1() throws Exception {
        String org = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <yourns:subtag/>\n  <someothertag/>\n</myns:root>";
        String snippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <yourns:subtag/>\n</myns:root>";
        String modSnippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <yourns:subtag extra=\"extra\">\n    Text content\n    <ASubTag attr=\"something\"/>\n    More text\n  </yourns:subtag>\n</myns:root>";
        String target = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <yourns:subtag extra=\"extra\">\n    Text content\n    <ASubTag attr=\"something\"/>\n    More text\n  </yourns:subtag>\n  <someothertag/>\n</myns:root>";
        this.testSnippetGetModPut(org, snippet, modSnippet, target);
    }

    public void testXMLSnippet2() throws Exception {
        String org = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <yourns:subtag/>\n  <someothertag/>\n</myns:root>";
        String snippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <yourns:subtag/>\n</myns:root>";
        String modSnippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n</myns:root>";
        String target = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <someothertag/>\n</myns:root>";
        this.testSnippetGetModPut(org, snippet, modSnippet, target);
    }

    public void testXMLSnippet3() throws Exception {
        String org = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <yourns:subtag/>\n  <yourns:subtag>\n    With some content\n  </yourns:subtag>\n  <someothertag/>\n</myns:root>";
        String snippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <yourns:subtag/>\n  <yourns:subtag>\n    With some content\n  </yourns:subtag>\n</myns:root>";
        String modSnippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <yourns:subtag extra=\"extra\">\n    Text content\n    <ASubTag attr=\"something\"/>\n    More text\n  </yourns:subtag>\n  <yourns:subtag/>\n  <yourns:subtag>\n    Different content\n  </yourns:subtag>\n</myns:root>";
        String target = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <yourns:subtag extra=\"extra\">\n    Text content\n    <ASubTag attr=\"something\"/>\n    More text\n  </yourns:subtag>\n  <yourns:subtag/>\n  <yourns:subtag>\n    Different content\n  </yourns:subtag>\n  <someothertag/>\n</myns:root>";
        this.testSnippetGetModPut(org, snippet, modSnippet, target);
    }

    public void testXMLSnippet4() throws Exception {
        String org = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <someothertag/>\n</myns:root>";
        String snippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n</myns:root>";
        String modSnippet = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <yourns:subtag/>\n</myns:root>";
        String target = "<myns:root xmlns:myns=\"http://somewhere.com/testnamespace\" xmlns:yourns=\"http://somewhereelse.com\">\n  <sometag/>\n  <someothertag/>\n  <yourns:subtag/>\n</myns:root>";
        this.testSnippetGetModPut(org, snippet, modSnippet, target);
    }

    private void testSnippetGetModPut(String org, String snippet, String modSnippet, String target) throws IOException, JDOMException {
        File orgFile = new File(this.tempdir, "org.xml");
        this.createTextFile(orgFile, org);
        String sn = XMLUtil.getXMLSnippet((File)orgFile, (String)"/myns:root/yourns:subtag");
        XMLUtilTest.assertEquals((String)XMLUtilTest.normXML(snippet), (String)XMLUtilTest.normXML(sn));
        File targetFile = new File(this.tempdir, "target.xml");
        this.copyFile(orgFile, targetFile);
        XMLUtil.putXMLSnippet((String)modSnippet, (File)targetFile, (String)"/myns:root/yourns:subtag");
        XMLUtilTest.assertEquals((String)XMLUtilTest.normXML(target), (String)XMLUtilTest.normXML(this.readTextFile(targetFile)));
    }

    public void testCanonicalize() throws Exception {
        SAXBuilder builder = new SAXBuilder();
        String xml1 = "<test a='a' b='b'/>";
        String xml2 = "<test b='b' a='a'/>";
        Element el1 = builder.build((InputStream)new ByteArrayInputStream(xml1.getBytes())).getRootElement();
        Element el2 = builder.build((InputStream)new ByteArrayInputStream(xml2.getBytes())).getRootElement();
        XMLUtilTest.assertEquals((String)XMLUtil.canonicalize((Element)el1), (String)XMLUtil.canonicalize((Element)el2));
    }

    private void createTextFile(File file, String text) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            InputStreamHelper.drain((InputStream)new ByteArrayInputStream(text.getBytes()), (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private String readTextFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            String string = new String(InputStreamHelper.drain((InputStream)in));
            return string;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private void copyFile(File org, File dest) throws IOException {
        FileInputStream in = new FileInputStream(org);
        FileOutputStream out = new FileOutputStream(dest);
        try {
            InputStreamHelper.drain((InputStream)in, (OutputStream)out);
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private static String normXML(String s) throws JDOMException, IOException {
        String s2 = XMLUtilTest.stripComment(s);
        String s3 = XMLUtilTest.stripProlog(s2);
        Document d = new SAXBuilder().build((InputStream)new ByteArrayInputStream(s3.getBytes()));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(d);
    }

    private static String stripComment(String s) {
        return s.replaceAll("<!--(.*?)-->", "");
    }

    private static String stripProlog(String s) {
        return s.replaceAll("<\\?(.*?)\\?>", "");
    }
}

