/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.ui.xef.editor.SnippetRepresentingXMLInstanceElements;
import org.eclipse.stp.ui.xef.editor.XefEditMasterDetailsBlock;
import org.eclipse.stp.ui.xef.editor.XefEditPage;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

class DeleteElementAction
extends Action {
    boolean interactive = true;
    private final XefEditMasterDetailsBlock block;
    private final XefEditPage editPage;

    DeleteElementAction(XefEditMasterDetailsBlock b, XefEditPage page) {
        super(ActionFactory.DELETE.getId());
        this.block = b;
        this.editPage = page;
    }

    public void run() {
        boolean goAhead;
        ISelection sel = this.block.viewer.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)sel;
        Object el = ssel.getFirstElement();
        ArrayList<XMLInstanceElement> toBeDeleted = new ArrayList<XMLInstanceElement>();
        if (el instanceof XMLInstanceElement) {
            toBeDeleted.add((XMLInstanceElement)el);
        } else if (el instanceof SnippetRepresentingXMLInstanceElements) {
            toBeDeleted.addAll(((SnippetRepresentingXMLInstanceElements)el).getElements());
        }
        if (toBeDeleted.size() == 0) {
            return;
        }
        boolean bl = goAhead = !this.interactive || MessageDialog.openQuestion((Shell)this.editPage.getSite().getShell(), (String)"Delete Policy", (String)("Delete " + el.toString() + "?"));
        if (!goAhead) {
            return;
        }
        for (XMLInstanceElement pi : toBeDeleted) {
            if (pi.getParent() == null) {
                this.block.policies.remove(pi);
                this.block.setDirty(true);
                continue;
            }
            pi.getParent().removeChild(pi);
            this.block.setDirty(true);
        }
        this.block.viewer.refresh();
    }

    public String getText() {
        return "Delete";
    }

    public ImageDescriptor getImageDescriptor() {
        return this.editPage.getSite().getWorkbenchWindow().getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }
}

