/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaRegistry {
    private static final SchemaRegistry SINGLETON;
    private final SchemaParser parser;
    private Map<String, List<SchemaElement>> schemas = new HashMap<String, List<SchemaElement>>();

    static {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        SINGLETON = new SchemaRegistry();
    }

    public SchemaRegistry() {
        try {
            this.parser = new SchemaParser();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static SchemaRegistry getDefault() {
        return SINGLETON;
    }

    public void clear() {
        this.schemas = new HashMap<String, List<SchemaElement>>();
    }

    public List<SchemaElement> resolveSchemaFromURL(String url, ISchemaProvider ... providers) throws Exception {
        return this.parser.parseAndRegister(url, providers);
    }

    public List<SchemaElement> resolveSchemaFromXML(String xml, boolean cache, ISchemaProvider ... providers) throws Exception {
        File temp = File.createTempFile("temp", "xsd");
        try {
            FileOutputStream os = new FileOutputStream(temp);
            try {
                InputStreamHelper.drain(new ByteArrayInputStream(xml.getBytes()), os);
            }
            finally {
                ((OutputStream)os).close();
            }
            List<SchemaElement> elements = new LinkedList<SchemaElement>();
            String ns = this.parser.parse(temp.toURI().toString(), elements, providers);
            if (cache) {
                if (!this.schemas.containsKey(ns)) {
                    this.registerSchema(ns, elements);
                } else {
                    elements = this.schemas.get(ns);
                }
            }
            LinkedList<SchemaElement> linkedList = elements;
            return linkedList;
        }
        finally {
            temp.delete();
        }
    }

    private void registerSchema(String uri, List<SchemaElement> topElements) {
        this.schemas.put(uri, topElements);
    }

    public List<SchemaElement> getEntryElements(String uri, boolean resolve, boolean cache, ISchemaProvider ... providers) {
        List<SchemaElement> els = null;
        if (cache) {
            els = this.schemas.get(uri);
        }
        if (els == null && resolve) {
            try {
                ISchemaProvider[] iSchemaProviderArray = providers;
                int n = 0;
                int n2 = iSchemaProviderArray.length;
                while (n < n2) {
                    ISchemaProvider provider = iSchemaProviderArray[n];
                    String schema = provider.getSchema(uri);
                    if (schema != null) {
                        return this.resolveSchemaFromXML(schema, cache, providers);
                    }
                    ++n;
                }
                return this.resolveSchemaFromURL(uri, providers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return els;
    }

    public SchemaElement getSchemaElement(String uri, String name, boolean cache, ISchemaProvider ... providers) {
        List<SchemaElement> els = this.getEntryElements(uri, true, cache, providers);
        if (els != null) {
            for (SchemaElement el : els) {
                if (!el.getName().equals(name)) continue;
                return el;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SchemaParser
    implements DOMErrorHandler {
        private final DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        private final XSImplementation xsImpl = (XSImplementation)this.registry.getDOMImplementation("XS-Loader");
        private final XSLoader schemaLoader = this.xsImpl.createXSLoader(null);
        private final DOMConfiguration domConfig;
        private final SchemaProviderResourceResolver resolver = new SchemaProviderResourceResolver();

        private SchemaParser() throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            this.domConfig = this.schemaLoader.getConfig();
            this.domConfig.setParameter("error-handler", this);
            this.domConfig.setParameter("validate", Boolean.TRUE);
            this.domConfig.setParameter("resource-resolver", this.resolver);
        }

        private synchronized String parse(String uri, List<SchemaElement> elements, ISchemaProvider ... providers) {
            try {
                this.resolver.setProviders(providers);
                XSModel model = this.schemaLoader.loadURI(uri);
                if (model == null) {
                    throw new NullPointerException("No document found at " + uri);
                }
                elements.addAll(this.initTopLevelEntryElements(model));
                XSNamespaceItemList nsItems = model.getNamespaceItems();
                int i = 0;
                while (i < nsItems.getLength()) {
                    XSNamespaceItem nsItem = nsItems.item(i);
                    if (!"http://www.w3.org/2001/XMLSchema".equals(nsItem.getSchemaNamespace())) {
                        String string = nsItem.getSchemaNamespace();
                        return string;
                    }
                    ++i;
                }
                return null;
            }
            finally {
                this.resolver.setProviders(new ISchemaProvider[0]);
            }
        }

        private synchronized List<SchemaElement> parseAndRegister(String uri, ISchemaProvider ... providers) {
            ArrayList<SchemaElement> entryElements = new ArrayList<SchemaElement>();
            String ns = this.parse(uri, entryElements, providers);
            SchemaRegistry.this.registerSchema(ns, entryElements);
            return entryElements;
        }

        @Override
        public boolean handleError(DOMError err) {
            System.out.println("*** Error " + err.getMessage());
            ((Throwable)err.getRelatedException()).printStackTrace();
            return false;
        }

        private List<SchemaElement> initTopLevelEntryElements(XSModel model) {
            LinkedList<XSElementDeclaration> topElements = new LinkedList<XSElementDeclaration>();
            HashSet<XSElementDeclaration> referencedElements = new HashSet<XSElementDeclaration>();
            XSNamedMap map = model.getComponents((short)2);
            int i = 0;
            while (i < map.getLength()) {
                XSElementDeclaration element = (XSElementDeclaration)map.item(i);
                topElements.add(element);
                this.initTopLevelEntryElements(element, referencedElements);
                ++i;
            }
            for (XSElementDeclaration referenced : referencedElements) {
                topElements.remove(referenced);
            }
            ArrayList<SchemaElement> l = new ArrayList<SchemaElement>(topElements.size());
            for (XSElementDeclaration element : topElements) {
                SchemaElement se = new SchemaElement(element, null, null);
                l.add(se);
            }
            return l;
        }

        private void initTopLevelEntryElements(XSElementDeclaration element, Set<XSElementDeclaration> referencedElements) {
            XSTerm groupTerm;
            XSComplexTypeDefinition ctd;
            XSParticle groupParticle;
            XSTypeDefinition typeDef = element.getTypeDefinition();
            if (typeDef instanceof XSComplexTypeDefinition && (groupParticle = (ctd = (XSComplexTypeDefinition)typeDef).getParticle()) != null && (groupTerm = groupParticle.getTerm()) instanceof XSModelGroup) {
                XSModelGroup group = (XSModelGroup)groupTerm;
                XSObjectList elements = group.getParticles();
                this.initTopLevelEntryElements(elements, referencedElements);
            }
        }

        private void initTopLevelEntryElements(XSObjectList elements, Set<XSElementDeclaration> referencedElements) {
            int i = 0;
            while (i < elements.getLength()) {
                XSObject obj = elements.item(i);
                if (obj instanceof XSParticle) {
                    XSParticle particle = (XSParticle)obj;
                    XSTerm particleTerm = particle.getTerm();
                    if (particleTerm instanceof XSElementDeclaration) {
                        XSElementDeclaration referencedElement = (XSElementDeclaration)particleTerm;
                        if (!referencedElements.contains(referencedElement)) {
                            referencedElements.add(referencedElement);
                            this.initTopLevelEntryElements(referencedElement, referencedElements);
                        }
                    } else if (particleTerm instanceof XSModelGroup) {
                        XSModelGroup group = (XSModelGroup)particleTerm;
                        XSObjectList groupElements = group.getParticles();
                        this.initTopLevelEntryElements(groupElements, referencedElements);
                    }
                }
                ++i;
            }
        }
    }

    private static class SchemaProviderResourceResolver
    implements LSResourceResolver {
        private ISchemaProvider[] providers = new ISchemaProvider[0];

        private SchemaProviderResourceResolver() {
        }

        void setProviders(ISchemaProvider ... p) {
            this.providers = p;
        }

        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            ISchemaProvider[] iSchemaProviderArray = this.providers;
            int n = 0;
            int n2 = iSchemaProviderArray.length;
            while (n < n2) {
                ISchemaProvider p = iSchemaProviderArray[n];
                String schema = p.getSchema(namespaceURI);
                if (schema != null) {
                    return new DOMInputImpl(publicId, systemId, baseURI, schema, null);
                }
                ++n;
            }
            return null;
        }
    }
}

