/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.stp.xef.DocumentNamespaceContext;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final DOMImplementationLS DOM_LS;
    private static final XPathFactory XPATH_FACTORY;
    private static final LSSerializer LS_SERIALIZER;
    private static LSParser LS_PARSER;
    private static final SAXBuilder SAX_BUILDER;
    private static final XMLOutputter XML_OUTPUTTER;

    static {
        XPATH_FACTORY = XPathFactory.newInstance();
        SAX_BUILDER = new SAXBuilder();
        XML_OUTPUTTER = new XMLOutputter(Format.getPrettyFormat());
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOM_LS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LS_PARSER = DOM_LS.createLSParser((short)1, null);
            LS_SERIALIZER = DOM_LS.createLSSerializer();
            DOMConfiguration config = LS_SERIALIZER.getDomConfig();
            config.setParameter("format-pretty-print", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String getXMLSnippet(File sourceXML, String xpath) throws IOException {
        String parentXPath = XMLUtil.getParentXPath(xpath);
        return XMLUtil.getXMLSnippet(sourceXML, xpath, parentXPath);
    }

    private static String getParentXPath(String xpath) {
        String parentXPath = null;
        int idx = xpath.lastIndexOf(47);
        if (idx >= 0) {
            parentXPath = xpath.substring(0, idx);
        }
        return parentXPath;
    }

    public static synchronized String getXMLSnippet(File sourceXML, String xpath, String parentXPath) throws IOException {
        Node parent;
        NodeList nodes;
        block4: {
            org.w3c.dom.Document doc = LS_PARSER.parseURI(sourceXML.toURI().toString());
            DocumentNamespaceContext dnc = new DocumentNamespaceContext(doc);
            XPath xp = XPATH_FACTORY.newXPath();
            xp.setNamespaceContext(dnc);
            nodes = (NodeList)xp.evaluate(xpath, doc, XPathConstants.NODESET);
            parent = XMLUtil.getParent(nodes);
            if (parent != null) break block4;
            XPath xp2 = XPATH_FACTORY.newXPath();
            xp2.setNamespaceContext(dnc);
            parent = (Node)xp2.evaluate(parentXPath, doc, XPathConstants.NODE);
            if (parent != null) break block4;
            return null;
        }
        try {
            DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            org.w3c.dom.Document newDoc = builder.newDocument();
            Node newParent = newDoc.adoptNode(parent.cloneNode(false));
            newDoc.appendChild(newParent);
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = newDoc.adoptNode(nodes.item(i));
                newParent.appendChild(node);
                ++i;
            }
            String result = LS_SERIALIZER.writeToString(newDoc);
            result = result.replaceAll("<\\?(.*?)\\?>", "");
            return result;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static Node getParent(NodeList nodes) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node cur = nodes.item(i);
            Node parent = cur.getParentNode();
            if (parent != null) {
                return parent;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void putXMLSnippet(String snippetXML, File targetXML, String xpath) throws IOException {
        block9: {
            os = null;
            input = XMLUtil.DOM_LS.createLSInput();
            input.setStringData(snippetXML);
            snippetDoc = XMLUtil.LS_PARSER.parse(input);
            targetDoc = XMLUtil.LS_PARSER.parseURI(targetXML.toURI().toString());
            xp = XMLUtil.XPATH_FACTORY.newXPath();
            dnc = new DocumentNamespaceContext(targetDoc);
            xp.setNamespaceContext(dnc);
            nodes = (NodeList)xp.evaluate(xpath, targetDoc, XPathConstants.NODESET);
            if (nodes.getLength() != 0) ** GOTO lbl32
            parentXPath = XMLUtil.getParentXPath(xpath);
            if (parentXPath != null) break block9;
            while (true) {
                InputStreamHelper.close(os);
                return;
            }
        }
        try {
            try {
                block11: {
                    xp2 = XMLUtil.XPATH_FACTORY.newXPath();
                    xp2.setNamespaceContext(dnc);
                    parent = (Node)xp2.evaluate(parentXPath, targetDoc, XPathConstants.NODE);
                    newChildren = snippetDoc.getDocumentElement().getChildNodes();
                    i = 0;
                    while (i < newChildren.getLength()) {
                        node = targetDoc.adoptNode(newChildren.item(i).cloneNode(true));
                        parent.appendChild(node);
                        ++i;
                    }
                    break block11;
lbl32:
                    // 1 sources

                    newChildren = snippetDoc.getDocumentElement().getChildNodes();
                    if ((parent = (firstEl = nodes.item(0)).getParentNode()) == null) ** continue;
                    i = 0;
                    while (i < newChildren.getLength()) {
                        node = targetDoc.adoptNode(newChildren.item(i).cloneNode(true));
                        parent.insertBefore(node, firstEl);
                        ++i;
                    }
                    i = 0;
                    while (i < nodes.getLength()) {
                        parent.removeChild(nodes.item(i));
                        ++i;
                    }
                }
                output = XMLUtil.DOM_LS.createLSOutput();
                os = new FileOutputStream(targetXML);
                output.setByteStream(os);
                XMLUtil.LS_SERIALIZER.write(targetDoc, output);
            }
            catch (Exception e) {
                ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        catch (Throwable var16_21) {
            InputStreamHelper.close(os);
            throw var16_21;
        }
        InputStreamHelper.close(os);
    }

    public static synchronized String normalizeXML(String xml) throws Exception {
        String s2 = XMLUtil.stripComment(xml);
        String s3 = XMLUtil.stripProlog(s2);
        return XML_OUTPUTTER.outputString(SAX_BUILDER.build((InputStream)new ByteArrayInputStream(s3.getBytes())));
    }

    private static String stripComment(String s) {
        return s.replaceAll("<!--(.*?)-->", "");
    }

    public static String stripProlog(String s) {
        return s.replaceAll("<\\?(.*?)\\?>", "");
    }

    public static String canonicalize(Element el) throws IOException, SAXException {
        Element cel = (Element)el.clone();
        XMLUtil.canonicalizeElement(cel);
        String formatted = new XMLOutputter(Format.getPrettyFormat()).outputString(cel);
        String f2 = formatted.replaceAll("<\\s*(\\S+)\\s*(\\s[^<>]*?)?\\s*/>", "<$1$2></$1>");
        return f2;
    }

    private static void canonicalizeElement(Element el) {
        TreeMap<String, Attribute> attrs = new TreeMap<String, Attribute>();
        for (Attribute a : new ArrayList(el.getAttributes())) {
            attrs.put(a.getName(), a);
            el.removeAttribute(a);
        }
        for (String attrName : attrs.keySet()) {
            el.setAttribute((Attribute)attrs.get(attrName));
        }
        for (Element e : el.getChildren()) {
            XMLUtil.canonicalizeElement(e);
        }
    }

    public static String mergeXMLBack(String originalXML, String selection, String newXML) throws Exception {
        Document orgdoc = SAX_BUILDER.build((InputStream)new ByteArrayInputStream(XMLUtil.normalizeXML(originalXML).getBytes()));
        Document seldoc = SAX_BUILDER.build((InputStream)new ByteArrayInputStream(XMLUtil.normalizeXML(selection).getBytes()));
        Document newdoc = SAX_BUILDER.build((InputStream)new ByteArrayInputStream(newXML.getBytes()));
        Element orgRoot = orgdoc.getRootElement();
        List elements = orgRoot.getChildren();
        Element orgRootCopy = (Element)orgRoot.clone();
        List originalElements = orgRootCopy.getChildren();
        ArrayList<String> elementXMLs = new ArrayList<String>(elements.size());
        for (Element el : elements) {
            elementXMLs.add(XMLUtil.canonicalize(el));
        }
        for (Element el : seldoc.getRootElement().getChildren()) {
            int idx = elementXMLs.indexOf(XMLUtil.canonicalize(el));
            if (idx == -1) continue;
            elements.remove(idx);
            elementXMLs.remove(idx);
        }
        List newElements = newdoc.getRootElement().cloneContent();
        for (Element el : newElements) {
            int insertIdx = XMLUtil.findInsertLocation(originalElements, elements, el, newElements);
            if (insertIdx == -1) {
                orgRoot.addContent((Content)el);
                continue;
            }
            orgRoot.addContent(insertIdx, (Content)el);
        }
        return new XMLOutputter(Format.getPrettyFormat()).outputString(orgdoc);
    }

    private static int findInsertLocation(List<Element> originalElements, List<Element> currentElements, Element element, List<Element> newElements) {
        int orgElIdx = -1;
        int i = 0;
        while (i < originalElements.size()) {
            Element el = originalElements.get(i);
            if (XMLUtil.elementNamesEqual(element, el)) {
                orgElIdx = i;
                break;
            }
            ++i;
        }
        if (orgElIdx == -1) {
            Element nextEl = XMLUtil.findNextNewElement(element, newElements);
            if (nextEl != null) {
                return XMLUtil.findInsertBeforeLocation(originalElements, currentElements, nextEl, newElements);
            }
            return -1;
        }
        int orgNextElIdx = -1;
        int i2 = orgElIdx + 1;
        while (i2 < originalElements.size()) {
            Element el = originalElements.get(i2);
            if (!XMLUtil.elementNamesEqual(element, el)) {
                orgNextElIdx = i2;
                break;
            }
            ++i2;
        }
        if (orgNextElIdx == -1) {
            return -1;
        }
        i2 = orgNextElIdx;
        while (i2 < originalElements.size()) {
            Element orgNextEl = originalElements.get(i2);
            int j = 0;
            while (j < currentElements.size()) {
                Element el = currentElements.get(j);
                if (XMLUtil.elementNamesEqual(orgNextEl, el)) {
                    return el.getParentElement().indexOf((Content)el);
                }
                ++j;
            }
            ++i2;
        }
        return -1;
    }

    private static Element findNextNewElement(Element element, List<Element> newElements) {
        int sz = newElements.size();
        int i = 0;
        while (i < sz) {
            if (newElements.get(i).equals((Object)element)) {
                while (i < sz && newElements.get(i).equals((Object)element)) {
                    ++i;
                }
                if (i < sz) {
                    return newElements.get(i);
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private static int findInsertBeforeLocation(List<Element> originalElements, List<Element> currentElements, Element element, List<Element> newElements) {
        for (Element el : originalElements) {
            Element parent;
            if (!XMLUtil.elementNamesEqual(element, el) || (parent = el.getParentElement()) == null) continue;
            return parent.indexOf((Content)el);
        }
        Element nextEl = XMLUtil.findNextNewElement(element, newElements);
        if (nextEl != null) {
            return XMLUtil.findInsertBeforeLocation(originalElements, currentElements, nextEl, newElements);
        }
        return -1;
    }

    private static boolean elementNamesEqual(Element el1, Element el2) {
        return el2.getName().equals(el1.getName()) && el2.getNamespace().equals((Object)el1.getNamespace());
    }

    public static String inferNamespacePrefix(String uri) {
        if (uri == null) {
            return null;
        }
        try {
            URI u = new URI(uri);
            String host = u.getHost();
            if (!host.endsWith(".org")) {
                int idx = host.indexOf(46);
                int idx2 = host.indexOf(46, idx + 1);
                return host.substring(idx + 1, idx2);
            }
            int idx = uri.lastIndexOf(47);
            return uri.substring(idx + 1);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

