/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class InputStreamHelper {
    static final int BLOCK_SIZE = 4096;

    private InputStreamHelper() {
    }

    public static void drain(InputStream r, OutputStream w) throws IOException {
        byte[] bytes = new byte[4096];
        try {
            int length = 0;
            int offset = 0;
            while ((length = r.read(bytes, offset, bytes.length - offset)) != -1) {
                if ((offset += length) != bytes.length) continue;
                w.write(bytes, 0, bytes.length);
                offset = 0;
            }
            if (offset != 0) {
                w.write(bytes, 0, offset);
            }
        }
        finally {
            bytes = null;
        }
    }

    public static byte[] drain(InputStream r) throws IOException {
        int avail = r.available();
        ByteArrayOutputStream bytes = avail > 0 ? new ByteArrayOutputStream(avail) : new ByteArrayOutputStream();
        InputStreamHelper.drain(r, bytes);
        return bytes.toByteArray();
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

