/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodelimpl.RegistryReader;

public class CSSProfileRegistry {
    private static CSSProfileRegistry fInstance = null;
    private Map fProfiles = new HashMap();

    public static synchronized CSSProfileRegistry getInstance() {
        if (fInstance == null) {
            fInstance = new CSSProfileRegistry();
        }
        return fInstance;
    }

    public Iterator getProfiles() {
        return Collections.unmodifiableCollection(this.fProfiles.values()).iterator();
    }

    public CSSProfile getProfile(String profileID) {
        return (CSSProfile)this.fProfiles.get(profileID);
    }

    public CSSProfile getDefaultProfile() {
        Iterator i = this.getProfiles();
        while (i.hasNext()) {
            CSSProfile profile = (CSSProfile)i.next();
            if (!profile.isDefault()) continue;
            return profile;
        }
        return null;
    }

    private CSSProfileRegistry() {
        Iterator i = new RegistryReader().enumProfiles();
        while (i.hasNext()) {
            Object profile = i.next();
            if (!(profile instanceof CSSProfile)) continue;
            this.fProfiles.put(((CSSProfile)profile).getProfileID(), profile);
        }
    }
}

