/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.jee.archive.AbstractArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.IArchiveResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorComponentNestedJARArchiveLoadAdapter
extends AbstractArchiveLoadAdapter {
    private List<IFile> iFiles;
    private int sourceSegmentCount;
    private int outputSegmentCount;
    private Map<IPath, IFile> pathsToIFiles;
    private Map<IPath, IArchiveResource> pathsToIArchiveResources;
    private IContainer sourceContainer;
    private boolean indexed = false;
    private List<IArchiveResource> fullIndex = null;

    public ConnectorComponentNestedJARArchiveLoadAdapter(List<IFile> iFiles, IContainer sourceContainer, IFolder javaOutputFolder) {
        this.iFiles = iFiles;
        this.sourceContainer = sourceContainer;
        this.sourceSegmentCount = sourceContainer.getProjectRelativePath().segmentCount();
        this.outputSegmentCount = javaOutputFolder.getProjectRelativePath().segmentCount();
    }

    public String toString() {
        int packageLength = ((Object)((Object)this)).getClass().getPackage().getName().length() + 1;
        StringBuffer buffer = new StringBuffer(((Object)((Object)this)).getClass().getName().substring(packageLength));
        buffer.append(", Source Container: ");
        buffer.append(this.sourceContainer.getName());
        return buffer.toString();
    }

    public List<IArchiveResource> getArchiveResources() {
        if (!this.indexed) {
            this.indexed = true;
            this.pathsToIFiles = new HashMap<IPath, IFile>();
            this.pathsToIArchiveResources = new HashMap<IPath, IArchiveResource>();
            for (IFile iFile : this.iFiles) {
                IPath relPath = JavaEEArchiveUtilities.isClass(iFile) ? this.getRelativePath(iFile, this.outputSegmentCount) : this.getRelativePath(iFile, this.sourceSegmentCount);
                this.addFile(iFile, relPath);
            }
            Path manifestPath = new Path("META-INF/MANIFEST.MF");
            if (!this.pathsToIArchiveResources.containsKey(manifestPath)) {
                IArchiveResource manifest = this.createManifest((IPath)manifestPath);
                this.pathsToIArchiveResources.put(manifest.getPath(), manifest);
            }
            ArrayList<IArchiveResource> list = new ArrayList<IArchiveResource>();
            list.addAll(this.pathsToIArchiveResources.values());
            this.fullIndex = Collections.unmodifiableList(list);
        }
        return this.fullIndex;
    }

    protected void addFile(IFile iFile, IPath relPath) {
        IArchiveResource aFile = this.createFile(iFile, relPath);
        this.pathsToIArchiveResources.put(aFile.getPath(), aFile);
        this.pathsToIFiles.put(aFile.getPath(), iFile);
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    private IArchiveResource createFile(IFile iFile, IPath relPath) {
        IArchiveResource cFile = this.createFile(relPath);
        cFile.setLastModified(this.getLastModified((IResource)iFile));
        return cFile;
    }

    private IPath getRelativePath(IFile file, int parentSegmentCount) {
        return file.getProjectRelativePath().removeFirstSegments(parentSegmentCount);
    }

    public boolean containsArchiveResource(IPath resourcePath) {
        if (!this.indexed) {
            this.getArchiveResources();
        }
        return this.pathsToIArchiveResources.containsKey(resourcePath);
    }

    public IArchiveResource getArchiveResource(IPath resourcePath) throws FileNotFoundException {
        if (!this.indexed) {
            this.getArchiveResources();
        }
        return this.pathsToIArchiveResources.get(resourcePath);
    }

    public InputStream getInputStream(IArchiveResource archiveResource) throws IOException, FileNotFoundException {
        IFile file = this.pathsToIFiles.get(archiveResource.getPath());
        if (file != null) {
            try {
                return file.getContents();
            }
            catch (CoreException core) {
                throw new IOException("Unable to get contents from " + file.getProjectRelativePath() + " message " + core.getLocalizedMessage());
            }
        }
        throw new FileNotFoundException(archiveResource.getPath().toString());
    }

    public boolean containsModelObject(IPath modelObjectPath) {
        return false;
    }

    public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
        return null;
    }
}

