/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.content.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentAttribute;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentType;
import org.eclipse.jpt.ui.internal.details.PersistentAttributeDetailsPage;
import org.eclipse.jpt.ui.internal.java.details.IAttributeMappingUiProvider;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.jpt.ui.internal.xml.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.xml.details.XmlJavaAttributeChooser;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlPersistentAttributeDetailsPage
extends PersistentAttributeDetailsPage {
    private XmlJavaAttributeChooser javaAttributeChooser;
    private Adapter persistentTypeListener;
    private IPersistentType persistentType;

    public XmlPersistentAttributeDetailsPage(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, widgetFactory);
        this.buildPersistentTypeListener();
    }

    private void buildPersistentTypeListener() {
        this.persistentTypeListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                XmlPersistentAttributeDetailsPage.this.persistentTypeChanged(notification);
            }
        };
    }

    void persistentTypeChanged(Notification notification) {
        if (notification.getFeatureID(XmlPersistentType.class) == 3) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    XmlPersistentAttributeDetailsPage.this.updateEnbabledState();
                }
            });
        }
    }

    protected void initializeLayout(Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, false));
        CommonWidgets.buildJavaAttributeNameLabel(composite, this.getWidgetFactory());
        this.javaAttributeChooser = CommonWidgets.buildJavaAttributeChooser(composite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.javaAttributeChooser.getControl().setLayoutData((Object)gridData);
        this.buildMappingLabel(composite);
        CComboViewer mappingCombo = this.buildMappingCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        mappingCombo.getCombo().setLayoutData((Object)gridData);
        PageBook book = this.buildMappingPageBook(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        book.setLayoutData((Object)gridData);
    }

    protected void engageListeners() {
        super.engageListeners();
        if (this.getAttribute() != null) {
            this.persistentType = this.getAttribute().typeMapping().getPersistentType();
            this.persistentType.eAdapters().add((Object)this.persistentTypeListener);
        }
    }

    protected void disengageListeners() {
        if (this.persistentType != null) {
            this.persistentType.eAdapters().remove((Object)this.persistentTypeListener);
            this.persistentType = null;
        }
        super.disengageListeners();
    }

    protected void doPopulate(IJpaContentNode persistentAttributeNode) {
        super.doPopulate(persistentAttributeNode);
        if (persistentAttributeNode == null) {
            this.javaAttributeChooser.populate(null);
        } else {
            XmlAttributeMapping mapping = ((XmlPersistentAttribute)persistentAttributeNode).getMapping();
            this.javaAttributeChooser.populate((EObject)mapping);
            this.updateEnbabledState();
        }
    }

    protected void doPopulate() {
        super.doPopulate();
        this.javaAttributeChooser.populate();
        this.updateEnbabledState();
    }

    public void dispose() {
        this.javaAttributeChooser.dispose();
        super.dispose();
    }

    public void updateEnbabledState() {
        if (this.getAttribute() == null || this.getAttribute().eContainer() == null) {
            return;
        }
        boolean enabled = !((XmlPersistentAttribute)this.getAttribute()).isVirtual();
        this.updateEnabledState(enabled, this.getControl());
    }

    public void updateEnabledState(boolean enabled, Control control) {
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            ArrayIterator i = new ArrayIterator((Object[])((Composite)control).getChildren());
            while (i.hasNext()) {
                this.updateEnabledState(enabled, (Control)i.next());
            }
        }
    }

    protected IAttributeMappingUiProvider[] uiProvidersFor(IPersistentAttribute persistentAttribute) {
        return this.attributeMappingUiProviders().toArray(new IAttributeMappingUiProvider[this.attributeMappingUiProviders().size()]);
    }
}

