/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.IJpaDataSource;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaCoreFactory;
import org.eclipse.jpt.core.internal.JpaCorePackage;
import org.eclipse.jpt.core.internal.JpaDataSource;
import org.eclipse.jpt.core.internal.JpaEObject;
import org.eclipse.jpt.core.internal.JpaFile;
import org.eclipse.jpt.core.internal.JpaFileContentRegistry;
import org.eclipse.jpt.core.internal.JpaModel;
import org.eclipse.jpt.core.internal.JpaPlatformRegistry;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.java.JpaCompilationUnit;
import org.eclipse.jpt.core.internal.facet.JpaFacetUtils;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.JptDbPlugin;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProject
extends JpaEObject
implements IJpaProject {
    protected IProject project;
    protected IJpaPlatform platform;
    protected IJpaDataSource dataSource;
    protected static final boolean DISCOVER_ANNOTATED_CLASSES_EDEFAULT = false;
    protected boolean discoverAnnotatedClasses = false;
    protected boolean discoverAnnotatedClassesESet;
    protected EList<IJpaFile> files;
    private boolean filled = false;
    boolean resynching = false;
    boolean disposing = false;
    boolean needsToResynch = false;
    Job resynchJob;

    protected JpaProject() {
    }

    private Job getResynchJob() {
        if (this.resynchJob == null) {
            this.resynchJob = this.buildResynchJob();
        }
        return this.resynchJob;
    }

    private Job buildResynchJob() {
        Job job = new Job("Resynching JPA model ..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus iStatus = JpaProject.this.runResynch(monitor);
                    return iStatus;
                }
                finally {
                    JpaProject.this.resynching = false;
                    if (JpaProject.this.needsToResynch) {
                        JpaProject.this.resynch();
                    }
                }
            }
        };
        if (this.project == null) {
            throw new IllegalStateException("Project can not be null when the Resynch Job is built");
        }
        job.setRule((ISchedulingRule)this.project);
        return job;
    }

    private IStatus runResynch(IProgressMonitor monitor) {
        IContext contextHierarchy = this.getPlatform().buildProjectContext();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            this.getPlatform().resynch(contextHierarchy, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Throwable e) {
            JptCorePlugin.log(e);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected EClass eStaticClass() {
        return JpaCorePackage.Literals.JPA_PROJECT;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    void setProject(IProject theProject) {
        this.project = theProject;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.getProject());
    }

    @Override
    public IJpaModel getModel() {
        return (IJpaModel)this.eContainer();
    }

    public IJpaPlatform getPlatformGen() {
        return this.platform;
    }

    @Override
    public IJpaPlatform getPlatform() {
        if (this.platform == null) {
            this.setPlatform(JpaFacetUtils.getPlatform(this.project));
        }
        return this.getPlatformGen();
    }

    public void setPlatformGen(IJpaPlatform newPlatform) {
        IJpaPlatform oldPlatform = this.platform;
        this.platform = newPlatform;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPlatform, (Object)this.platform));
        }
    }

    public void setPlatform(IJpaPlatform jpaPlatform) {
        jpaPlatform.setProject(this);
        this.setPlatformGen(jpaPlatform);
    }

    @Override
    public void setPlatform(String platformId) {
        this.setPlatform(JpaPlatformRegistry.INSTANCE.getJpaPlatform(platformId));
    }

    public IJpaDataSource getDataSourceGen() {
        return this.dataSource;
    }

    @Override
    public synchronized IJpaDataSource getDataSource() {
        if (this.dataSource == null) {
            this.setDataSource(JpaFacetUtils.getConnectionName(this.project));
        }
        return this.getDataSourceGen();
    }

    public NotificationChain basicSetDataSource(IJpaDataSource newDataSource, NotificationChain msgs) {
        IJpaDataSource oldDataSource = this.dataSource;
        this.dataSource = newDataSource;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDataSource, (Object)newDataSource);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setDataSource(IJpaDataSource newDataSource) {
        if (newDataSource != this.dataSource) {
            NotificationChain msgs = null;
            if (this.dataSource != null) {
                msgs = ((InternalEObject)this.dataSource).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newDataSource != null) {
                msgs = ((InternalEObject)newDataSource).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetDataSource(newDataSource, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newDataSource, (Object)newDataSource));
        }
    }

    @Override
    public void setDataSource(String connectionProfileName) {
        if (this.dataSource == null) {
            JpaDataSource ds = JpaCoreFactory.eINSTANCE.createJpaDataSource();
            this.setDataSource(ds);
        }
        this.dataSource.setConnectionProfileName(connectionProfileName);
    }

    public boolean isDiscoverAnnotatedClassesGen() {
        return this.discoverAnnotatedClasses;
    }

    @Override
    public boolean isDiscoverAnnotatedClasses() {
        if (!this.isSetDiscoverAnnotatedClasses()) {
            this.setDiscoverAnnotatedClasses(JpaFacetUtils.getDiscoverAnnotatedClasses(this.project));
        }
        return this.isDiscoverAnnotatedClassesGen();
    }

    @Override
    public void setDiscoverAnnotatedClasses(boolean newDiscoverAnnotatedClasses) {
        boolean oldDiscoverAnnotatedClasses = this.discoverAnnotatedClasses;
        this.discoverAnnotatedClasses = newDiscoverAnnotatedClasses;
        boolean oldDiscoverAnnotatedClassesESet = this.discoverAnnotatedClassesESet;
        this.discoverAnnotatedClassesESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldDiscoverAnnotatedClasses, this.discoverAnnotatedClasses, !oldDiscoverAnnotatedClassesESet));
        }
    }

    public void unsetDiscoverAnnotatedClasses() {
        boolean oldDiscoverAnnotatedClasses = this.discoverAnnotatedClasses;
        boolean oldDiscoverAnnotatedClassesESet = this.discoverAnnotatedClassesESet;
        this.discoverAnnotatedClasses = false;
        this.discoverAnnotatedClassesESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, oldDiscoverAnnotatedClasses, false, oldDiscoverAnnotatedClassesESet));
        }
    }

    public boolean isSetDiscoverAnnotatedClasses() {
        return this.discoverAnnotatedClassesESet;
    }

    @Override
    public String rootDeployLocation() {
        String metaInfLocation = "";
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)this.project, (String)"jst.web")) {
                metaInfLocation = "WEB-INF/classes";
            }
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
        return metaInfLocation;
    }

    @Override
    public IJpaProject getJpaProject() {
        return this;
    }

    public EList<IJpaFile> getFiles() {
        if (this.files == null) {
            this.files = new EObjectContainmentEList(IJpaFile.class, (InternalEObject)this, 3);
        }
        return this.files;
    }

    void fill() throws CoreException {
        if (this.filled) {
            return;
        }
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy resource) throws CoreException {
                switch (resource.getType()) {
                    case 2: 
                    case 4: {
                        return true;
                    }
                    case 1: {
                        IFile file = (IFile)resource.requestResource();
                        if (JpaProject.this.getJpaFileInternal(file) != null) break;
                        JpaProject.this.createJpaFile(file);
                    }
                }
                return false;
            }
        };
        this.getProject().accept(visitor, 0);
        this.filled = true;
        this.resynch();
    }

    public boolean isFilled() {
        return this.filled;
    }

    @Override
    public synchronized IJpaFile getJpaFile(IFile file) {
        IJpaFile jpaFile = this.getJpaFileInternal(file);
        if (jpaFile != null) {
            return jpaFile;
        }
        if (!this.filled) {
            return this.createJpaFile(file);
        }
        return null;
    }

    synchronized IJpaFile getJpaFileInternal(IFile file) {
        for (IJpaFile next : this.getFiles()) {
            if (!next.getFile().equals((Object)file)) continue;
            return next;
        }
        return null;
    }

    @Override
    public Iterator<IJpaFile> jpaFiles() {
        return new CloneIterator(this.getFiles());
    }

    @Override
    public Collection<IJpaFile> jpaFiles(String contentType) {
        ArrayList<IJpaFile> jpaFiles = new ArrayList<IJpaFile>();
        Iterator<IJpaFile> stream = this.jpaFiles();
        while (stream.hasNext()) {
            IJpaFile next = stream.next();
            if (!next.getContentId().equals(contentType)) continue;
            jpaFiles.add(next);
        }
        return jpaFiles;
    }

    @Override
    public JavaPersistentType findJavaPersistentType(IType type) {
        if (type == null) {
            return null;
        }
        Collection<IJpaFile> persistenceFiles = this.jpaFiles("org.eclipse.jdt.core.javaSource");
        for (IJpaFile jpaFile : persistenceFiles) {
            JpaCompilationUnit compilationUnit = (JpaCompilationUnit)jpaFile.getContent();
            for (JavaPersistentType persistentType : compilationUnit.getTypes()) {
                if (!type.equals(persistentType.getType().getJdtMember())) continue;
                return persistentType;
            }
        }
        return null;
    }

    void dispose() {
        if (this.disposing) {
            return;
        }
        this.disposing = true;
        Job job = new Job("Disposing JPA project ..."){

            protected IStatus run(IProgressMonitor monitor) {
                JpaProject.this.dispose_();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)this.project);
        job.schedule();
    }

    private void dispose_() {
        for (IJpaFile jpaFile : new ArrayList<IJpaFile>((Collection<IJpaFile>)this.getFiles())) {
            ((JpaFile)jpaFile).dispose();
        }
        ((JpaModel)this.getModel()).getProjects().remove((Object)this);
    }

    void synchInternalResources(IResourceDelta delta) throws CoreException {
        delta.accept(this.buildResourceDeltaVisitor());
    }

    private IResourceDeltaVisitor buildResourceDeltaVisitor() {
        return new IResourceDeltaVisitor(){
            private IResource currentResource;
            {
                this.currentResource = JpaProject.this.getProject();
            }

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource res = delta.getResource();
                if (res.equals((Object)this.currentResource)) {
                    return true;
                }
                if (res.getType() == 1) {
                    IFile file = (IFile)res;
                    switch (delta.getKind()) {
                        case 1: {
                            if (JpaProject.this.getJpaFile(file) != null) break;
                            JpaProject.this.createJpaFile(file);
                            JpaProject.this.resynch();
                            break;
                        }
                        case 2: {
                            JpaFile jpaFile = (JpaFile)JpaProject.this.getJpaFile(file);
                            if (jpaFile == null) break;
                            jpaFile.dispose();
                            JpaProject.this.resynch();
                        }
                    }
                }
                return true;
            }
        };
    }

    synchronized IJpaFile createJpaFile(IFile file) {
        if (!JavaCore.create((IProject)this.getProject()).isOnClasspath((IResource)file)) {
            return null;
        }
        IJpaFile jpaFile = JpaFileContentRegistry.getFile(this, file);
        if (jpaFile != null) {
            this.getFiles().add((Object)jpaFile);
            return jpaFile;
        }
        return null;
    }

    void handleEvent(ElementChangedEvent event) {
        if (this.filled) {
            Iterator<IJpaFile> stream = this.jpaFiles();
            while (stream.hasNext()) {
                ((JpaFile)stream.next()).handleEvent(event);
            }
        }
    }

    @Override
    public Iterator<IMessage> validationMessages() {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.getPlatform().addToMessages(messages);
        return messages.iterator();
    }

    @Override
    public void resynch() {
        if (this.disposing || !this.filled) {
            return;
        }
        if (!this.resynching) {
            this.resynching = true;
            this.needsToResynch = false;
            this.getResynchJob().schedule();
        } else {
            this.needsToResynch = true;
            if (this.getResynchJob().getState() == 4) {
                this.getResynchJob().cancel();
            }
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetDataSource(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPlatform();
            }
            case 1: {
                return this.getDataSource();
            }
            case 2: {
                return this.isDiscoverAnnotatedClasses() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.getFiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPlatform((IJpaPlatform)newValue);
                return;
            }
            case 1: {
                this.setDataSource((IJpaDataSource)newValue);
                return;
            }
            case 2: {
                this.setDiscoverAnnotatedClasses((Boolean)newValue);
                return;
            }
            case 3: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPlatform((IJpaPlatform)null);
                return;
            }
            case 1: {
                this.setDataSource((IJpaDataSource)null);
                return;
            }
            case 2: {
                this.unsetDiscoverAnnotatedClasses();
                return;
            }
            case 3: {
                this.getFiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.platform != null;
            }
            case 1: {
                return this.dataSource != null;
            }
            case 2: {
                return this.isSetDiscoverAnnotatedClasses();
            }
            case 3: {
                return this.files != null && !this.files.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (" + this.getProject().toString() + ")");
        return result.toString();
    }

    @Override
    public ConnectionProfile connectionProfile() {
        String profileName = this.getDataSource().getConnectionProfileName();
        return JptDbPlugin.getDefault().getConnectionProfileRepository().profileNamed(profileName);
    }
}

