/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaOverride;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.mappings.IOverride;
import org.eclipse.jpt.utility.internal.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAssociationOverride
extends JavaOverride
implements IAssociationOverride {
    protected EList<IJoinColumn> specifiedJoinColumns;
    protected EList<IJoinColumn> defaultJoinColumns;
    public static final SimpleDeclarationAnnotationAdapter SINGLE_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AssociationOverride");
    public static final SimpleDeclarationAnnotationAdapter MULTIPLE_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AssociationOverrides");

    protected JavaAssociationOverride() {
        throw new UnsupportedOperationException("use JavaAssociationOverride(Owner, Member, IndexedDeclarationAnnotationAdapter)");
    }

    protected JavaAssociationOverride(IOverride.Owner owner, Member member, IndexedDeclarationAnnotationAdapter daa) {
        super(owner, member, daa);
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IJoinTable.class)) {
            case 2: {
                this.specifiedJoinColumnsChanged(notification);
                break;
            }
        }
    }

    void specifiedJoinColumnsChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.specifiedJoinColumnAdded(notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 5: {
                this.specifiedJoinColumnsAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.specifiedJoinColumnRemoved(notification.getPosition(), (IJoinColumn)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.specifiedJoinColumnsCleared((List)notification.getOldValue());
                    break;
                }
                this.specifiedJoinColumnsRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.specifiedJoinColumnSet(notification.getPosition(), (IJoinColumn)notification.getOldValue(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 7: {
                this.specifiedJoinColumnMoved(notification.getOldIntValue(), notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
        }
    }

    @Override
    protected String nameElementName() {
        return "name";
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_ASSOCIATION_OVERRIDE;
    }

    @Override
    public EList<IJoinColumn> getJoinColumns() {
        return this.getSpecifiedJoinColumns().isEmpty() ? this.getDefaultJoinColumns() : this.getSpecifiedJoinColumns();
    }

    @Override
    public EList<IJoinColumn> getSpecifiedJoinColumns() {
        if (this.specifiedJoinColumns == null) {
            this.specifiedJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 2);
        }
        return this.specifiedJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getDefaultJoinColumns() {
        if (this.defaultJoinColumns == null) {
            this.defaultJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 3);
        }
        return this.defaultJoinColumns;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getSpecifiedJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getDefaultJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getJoinColumns();
            }
            case 2: {
                return this.getSpecifiedJoinColumns();
            }
            case 3: {
                return this.getDefaultJoinColumns();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getSpecifiedJoinColumns().clear();
                this.getSpecifiedJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getDefaultJoinColumns().clear();
                this.getDefaultJoinColumns().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getSpecifiedJoinColumns().clear();
                return;
            }
            case 3: {
                this.getDefaultJoinColumns().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return !this.getJoinColumns().isEmpty();
            }
            case 2: {
                return this.specifiedJoinColumns != null && !this.specifiedJoinColumns.isEmpty();
            }
            case 3: {
                return this.defaultJoinColumns != null && !this.defaultJoinColumns.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IAssociationOverride.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IAssociationOverride.class) {
            switch (baseFeatureID) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public ITypeMapping typeMapping() {
        return (ITypeMapping)this.eContainer();
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.getSpecifiedJoinColumns().isEmpty();
    }

    @Override
    public IJoinColumn createJoinColumn(int index) {
        return this.createJavaJoinColumn(index);
    }

    private JavaJoinColumn createJavaJoinColumn(int index) {
        return JavaJoinColumn.createAssociationOverrideJoinColumn(this.getDeclarationAnnotationAdapter(), new IAssociationOverride.JoinColumnOwner(this), this.getMember(), index);
    }

    public void specifiedJoinColumnAdded(int index, IJoinColumn joinColumn) {
        if (((JavaJoinColumn)joinColumn).annotation(this.getMember().astRoot()) == null) {
            this.synchJoinColumnAnnotationsAfterAdd(index + 1);
            ((JavaJoinColumn)joinColumn).newAnnotation();
        }
    }

    public void specifiedJoinColumnsAdded(int index, List<IJoinColumn> joinColumns) {
        if (!joinColumns.isEmpty() && ((JavaJoinColumn)joinColumns.get(0)).annotation(this.getMember().astRoot()) == null) {
            this.synchJoinColumnAnnotationsAfterAdd(index + joinColumns.size());
            for (IJoinColumn joinColumn : joinColumns) {
                ((JavaJoinColumn)joinColumn).newAnnotation();
            }
        }
    }

    public void specifiedJoinColumnRemoved(int index, IJoinColumn joinColumn) {
        ((JavaJoinColumn)joinColumn).removeAnnotation();
        this.synchJoinColumnAnnotationsAfterRemove(index);
    }

    public void specifiedJoinColumnsRemoved(int[] indexes, List<IJoinColumn> joinColumns) {
        for (IJoinColumn joinColumn : joinColumns) {
            ((JavaJoinColumn)joinColumn).removeAnnotation();
        }
        this.synchJoinColumnAnnotationsAfterRemove(indexes[0]);
    }

    public void specifiedJoinColumnsCleared(List<IJoinColumn> joinColumns) {
        for (IJoinColumn joinColumn : joinColumns) {
            ((JavaJoinColumn)joinColumn).removeAnnotation();
        }
    }

    public void specifiedJoinColumnSet(int index, IJoinColumn oldJoinColumn, IJoinColumn newJoinColumn) {
        ((JavaJoinColumn)newJoinColumn).newAnnotation();
    }

    public void specifiedJoinColumnMoved(int sourceIndex, int targetIndex, IJoinColumn joinColumn) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchJoinColumnAnnotationsAfterAdd(int index) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int i = joinColumns.size();
        while (i-- > index) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchJoinColumnAnnotationsAfterRemove(int index) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int i = index;
        while (i < joinColumns.size()) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
            ++i;
        }
    }

    private void synch(IJoinColumn joinColumn, int index) {
        ((JavaJoinColumn)joinColumn).moveAnnotation(index);
    }

    @Override
    protected Iterator<String> candidateNames() {
        return this.getOwner().getTypeMapping().allOverridableAssociationNames();
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (IJoinColumn column : this.getJoinColumns()) {
            result = ((JavaJoinColumn)column).candidateValuesFor(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateSpecifiedJoinColumnsFromJava(astRoot);
    }

    /*
     * Unable to fully structure code
     */
    private void updateSpecifiedJoinColumnsFromJava(CompilationUnit astRoot) {
        block5: {
            joinColumns = this.getSpecifiedJoinColumns();
            persSize = joinColumns.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                joinColumn = (JavaJoinColumn)joinColumns.get(i);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                joinColumns.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                joinColumn = this.createJavaJoinColumn(javaSize);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getSpecifiedJoinColumns().add((Object)joinColumn);
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    static JavaAssociationOverride createAssociationOverride(IOverride.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaAssociationOverride(owner, member, JavaAssociationOverride.buildAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildAnnotationAdapter(int index) {
        return new CombinationIndexedDeclarationAnnotationAdapter(SINGLE_DECLARATION_ANNOTATION_ADAPTER, MULTIPLE_DECLARATION_ANNOTATION_ADAPTER, index, "javax.persistence.AssociationOverride");
    }
}

