/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.evaluation;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.evaluation.IterationTemplate;
import org.eclipse.ocl.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationTemplateClosure<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends IterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private OCLExpression<C> body;

    private IterationTemplateClosure(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v, OCLExpression<C> body) {
        super(v);
        this.body = body;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> IterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getInstance(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v, OCLExpression<C> body) {
        return new IterationTemplateClosure<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(v, body);
    }

    @Override
    protected Object evaluateResult(List<Variable<C, PM>> iterators, String resultName, Object bodyVal) {
        EvaluationEnvironment env = this.getEvalEnvironment();
        Set currVal = (Set)env.getValueOf(resultName);
        if (bodyVal == this.getOclInvalid()) {
            this.setDone(true);
            return this.getOclInvalid();
        }
        Collection newResults = CollectionUtil.createNewSet();
        if (bodyVal instanceof Collection) {
            Collection bodyColl = (Collection)bodyVal;
            for (Object next : bodyColl) {
                if (next == null || !currVal.add(next)) continue;
                newResults.add(next);
            }
        } else if (bodyVal != null && currVal.add(bodyVal)) {
            newResults.add(bodyVal);
        }
        if (!newResults.isEmpty()) {
            Object[] iteratorValues = this.pauseIterators(iterators);
            this.evaluate(newResults, iterators, this.body, resultName);
            this.resumeIterators(iterators, iteratorValues);
        }
        return currVal;
    }

    private Object[] pauseIterators(List<Variable<C, PM>> iterators) {
        Object[] result = new Object[iterators.size()];
        EvaluationEnvironment env = this.getEvalEnvironment();
        int i = 0;
        int n = result.length;
        while (i < n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            result[i] = env.remove(iterDecl.getName());
            ++i;
        }
        return result;
    }

    private void resumeIterators(List<Variable<C, PM>> iterators, Object[] values) {
        EvaluationEnvironment env = this.getEvalEnvironment();
        int i = 0;
        int n = values.length;
        while (i < n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            env.add(iterDecl.getName(), values[i]);
            ++i;
        }
    }
}

