/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ITraceMe;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class ModifyWorldTransform
implements IEmf2SvgConverter,
ITraceMe {
    private static final int XFORM_OFFSET = 0;
    private static final int MWT_OFFSET = 24;
    private int _mwt;
    private float[] _xform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};

    public void readEMFRecord(Record rec) throws IOException {
        this._xform = rec.getTransformAt(0);
        this._mwt = rec.getIntAt(24);
    }

    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        context.modifyWorldTransform(this._mwt, this._xform);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("XForm=(");
        int ix = 0;
        while (ix < 6) {
            this.addFloat(sb, this._xform[ix], ix < 5);
            ++ix;
        }
        switch (this._mwt) {
            case 1: {
                sb.append(", IDENTITY");
                break;
            }
            case 2: {
                sb.append(", LEFTMULTIPLY");
                break;
            }
            case 3: {
                sb.append(", RIGHTMULTIPLY");
                break;
            }
            default: {
                sb.append("(bad transform operation)");
            }
        }
        return sb.toString();
    }

    private void addFloat(StringBuffer sb, float f, boolean addComma) {
        sb.append(f);
        if (addComma) {
            sb.append(',');
        }
    }
}

