/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Untar
extends Expand {
    private UntarCompressionMethod compression = new UntarCompressionMethod();

    public void setCompression(UntarCompressionMethod method) {
        this.compression = method;
    }

    public void setEncoding(String encoding) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the encoding" + " attribute", this.getLocation());
    }

    protected void expandFile(FileUtils fileUtils, File srcF, File dir) {
        FileInputStream fis = null;
        TarInputStream tis = null;
        try {
            this.log("Expanding: " + srcF + " into " + dir, 2);
            fis = new FileInputStream(srcF);
            tis = new TarInputStream(this.compression.decompress(srcF, new BufferedInputStream(fis)));
            TarEntry te = null;
            while ((te = tis.getNextEntry()) != null) {
                this.extractFile(fileUtils, srcF, dir, tis, te.getName(), te.getModTime(), te.isDirectory());
            }
            this.log("expand complete", 3);
        }
        catch (IOException ioe) {
            throw new BuildException("Error while expanding " + srcF.getPath(), ioe, this.getLocation());
        }
        finally {
            if (tis != null) {
                try {
                    tis.close();
                }
                catch (IOException e) {}
            } else if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static final class UntarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public UntarCompressionMethod() {
            this.setValue(NONE);
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private InputStream decompress(File file, InputStream istream) throws IOException, BuildException {
            String value = this.getValue();
            if (GZIP.equals(value)) {
                return new GZIPInputStream(istream);
            }
            if (BZIP2.equals(value)) {
                char[] magic = new char[]{'B', 'Z'};
                int i = 0;
                while (i < magic.length) {
                    if (istream.read() != magic[i]) {
                        throw new BuildException("Invalid bz2 file." + file.toString());
                    }
                    ++i;
                }
                return new CBZip2InputStream(istream);
            }
            return istream;
        }
    }
}

