/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.MissingResourceException;

public class Currency
extends MeasureUnit
implements Serializable {
    private static final long serialVersionUID = -5839973855554750484L;
    private static final boolean DEBUG = ICUDebug.enabled("currency");
    private String isoCode;
    public static final int SYMBOL_NAME = 0;
    public static final int LONG_NAME = 1;
    private static ServiceShim shim;
    private static final int[] LAST_RESORT_DATA;
    private static final int[] POW10;
    private ULocale validLocale;
    private ULocale actualLocale;

    static {
        int[] nArray = new int[2];
        nArray[0] = 2;
        LAST_RESORT_DATA = nArray;
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.icu.util.CurrencyServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static Currency getInstance(Locale locale) {
        return Currency.getInstance(ULocale.forLocale(locale));
    }

    public static Currency getInstance(ULocale locale) {
        String currency = locale.getKeywordValue("currency");
        if (currency != null) {
            return Currency.getInstance(currency);
        }
        if (shim == null) {
            return Currency.createCurrency(locale);
        }
        return shim.createInstance(locale);
    }

    static Currency createCurrency(ULocale loc) {
        String country = loc.getCountry();
        String variant = loc.getVariant();
        if (variant.equals("PREEURO") || variant.equals("EURO")) {
            country = String.valueOf(country) + '_' + variant;
        }
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt36b", "CurrencyData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        ICUResourceBundle cm = bundle.get("CurrencyMap");
        String curriso = null;
        try {
            curriso = cm.getString(country);
            if (curriso != null) {
                return new Currency(curriso);
            }
        }
        catch (MissingResourceException missingResourceException) {
            try {
                String rep = ULocale.getCurrentCountryID(country);
                if (DEBUG) {
                    System.out.println("DEBUG: oldID: " + country + " newID:" + rep);
                }
                if (rep != country && (curriso = cm.getString(rep)) != null) {
                    return new Currency(curriso);
                }
            }
            catch (MissingResourceException missingResourceException2) {}
        }
        return null;
    }

    public static Currency getInstance(String theISOCode) {
        return new Currency(theISOCode);
    }

    public static Object registerInstance(Currency currency, ULocale locale) {
        return Currency.getShim().registerInstance(currency, locale);
    }

    public static boolean unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt36b");
        }
        return shim.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt36b");
        }
        return shim.getAvailableULocales();
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        try {
            Currency c = (Currency)rhs;
            return this.isoCode.equals(c.isoCode);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String getCurrencyCode() {
        return this.isoCode;
    }

    public String getSymbol() {
        return this.getSymbol(ULocale.getDefault());
    }

    public String getSymbol(Locale loc) {
        return this.getSymbol(ULocale.forLocale(loc));
    }

    public String getSymbol(ULocale uloc) {
        return this.getName(uloc, 0, new boolean[1]);
    }

    public String getName(Locale locale, int nameStyle, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale), nameStyle, isChoiceFormat);
    }

    public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle < 0 || nameStyle > 1) {
            throw new IllegalArgumentException();
        }
        String s = null;
        try {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt36b", locale);
            ICUResourceBundle currencies = rb.get("Currencies");
            s = currencies.getWithFallback(this.isoCode).getString(nameStyle);
        }
        catch (MissingResourceException missingResourceException) {}
        isChoiceFormat[0] = false;
        if (s != null) {
            int i = 0;
            while (i < s.length() && s.charAt(i) == '=' && i < 2) {
                ++i;
            }
            boolean bl = isChoiceFormat[0] = i == 1;
            if (i != 0) {
                s = s.substring(1);
            }
            return s;
        }
        return this.isoCode;
    }

    public static String parse(ULocale locale, String text, ParsePosition pos) {
        int start = pos.getIndex();
        String fragment = text.substring(start);
        String iso = null;
        int max = 0;
        while (locale != null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt36b", locale);
            try {
                ICUResourceBundle currencies = rb.get("Currencies");
                int i = 0;
                while (i < currencies.getSize()) {
                    ICUResourceBundle item = currencies.get(i);
                    String name = item.getString(0);
                    if (name.length() >= 1) {
                        if (name.charAt(0) == '=' && (name = name.substring(1)).length() > 0 && name.charAt(0) != '=') {
                            ChoiceFormat choice = new ChoiceFormat(name);
                            choice.parse(text, pos);
                            int len = pos.getIndex() - start;
                            if (len > max) {
                                iso = item.getKey();
                                max = len;
                            }
                            pos.setIndex(start);
                        } else if (name.length() > max && fragment.startsWith(name)) {
                            iso = item.getKey();
                            max = name.length();
                        }
                    }
                    ++i;
                }
            }
            catch (MissingResourceException missingResourceException) {}
            locale = locale.getFallback();
        }
        if (max < 3 && text.length() - start >= 3) {
            boolean valid = true;
            int k = 0;
            while (k < 3) {
                char ch = text.charAt(start + k);
                if (ch < 'A' || ch > 'Z') {
                    valid = false;
                    break;
                }
                ++k;
            }
            if (valid) {
                iso = text.substring(start, start + 3);
                max = 3;
            }
        }
        pos.setIndex(start + max);
        return iso;
    }

    public int getDefaultFractionDigits() {
        return this.findData()[0];
    }

    public double getRoundingIncrement() {
        int[] data = this.findData();
        int data1 = data[1];
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = data[0];
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    public String toString() {
        return this.isoCode;
    }

    protected Currency(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private int[] findData() {
        try {
            ICUResourceBundle root = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt36b", "CurrencyData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            ICUResourceBundle currencyMeta = root.get("CurrencyMeta");
            int[] i = currencyMeta.get(this.isoCode).getIntVector();
            if (i == null) {
                i = currencyMeta.get("DEFAULT").getIntVector();
            }
            if (i != null && i.length >= 2) {
                return i;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return LAST_RESORT_DATA;
    }

    public final ULocale getLocale(ULocale.Type type) {
        return ULocale.ROOT;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract ULocale[] getAvailableULocales();

        abstract Locale[] getAvailableLocales();

        abstract Currency createInstance(ULocale var1);

        abstract Object registerInstance(Currency var1, ULocale var2);

        abstract boolean unregister(Object var1);
    }
}

