/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.GenScope;
import org.eclipse.jpt.gen.internal.GenTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageGenerator {
    private final Config config;
    private final EntityGenerator.Config entityConfig;
    private final GenScope scope;
    private final EntityGenerator.OverwriteConfirmer overwriteConfirmer;
    private final IProgressMonitor monitor;

    public static void generateEntities(Config config, EntityGenerator.Config entityConfig, Collection<Table> tables, EntityGenerator.OverwriteConfirmer overwriteConfirmer, IProgressMonitor monitor) {
        if (config == null || entityConfig == null || tables == null) {
            throw new NullPointerException();
        }
        try {
            monitor.beginTask("", 1000);
            new PackageGenerator(config, entityConfig, tables, overwriteConfirmer, monitor).generateEntities();
        }
        finally {
            monitor.done();
        }
    }

    private PackageGenerator(Config config, EntityGenerator.Config entityConfig, Collection<Table> tables, EntityGenerator.OverwriteConfirmer overwriteConfirmer, IProgressMonitor monitor) {
        this.config = config;
        this.entityConfig = entityConfig;
        this.scope = new GenScope(tables, entityConfig, (IProgressMonitor)new SubProgressMonitor(monitor, 800));
        this.overwriteConfirmer = overwriteConfirmer;
        this.monitor = monitor;
    }

    private void generateEntities() {
        int size = this.scope.numEntityTables();
        int ticks = 200 / size;
        Iterator<GenTable> stream = this.scope.entityTables();
        while (stream.hasNext()) {
            this.checkCanceled();
            this.buildEntity(stream.next(), (IProgressMonitor)new SubProgressMonitor(this.monitor, ticks));
        }
    }

    private void checkCanceled() {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void buildEntity(GenTable genTable, IProgressMonitor monitor) {
        EntityGenerator.generateEntity(this.entityConfig, this.config.getPackageFragment(), genTable, this.overwriteConfirmer, monitor);
    }

    public static class Config {
        private IPackageFragment packageFragment;

        public IPackageFragment getPackageFragment() {
            return this.packageFragment;
        }

        public void setPackageFragment(IPackageFragment packageFragment) {
            this.packageFragment = packageFragment;
        }
    }
}

