/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.internal.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;

public abstract class AbstractExampleWizard
extends Wizard
implements INewWizard {
    public boolean performFinish() {
        final Collection projectDescriptors = this.getProjectDescriptors();
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    WorkspaceModifyOperation op = new WorkspaceModifyOperation(this, projectDescriptors){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Collection val$projectDescriptors;
                        {
                            this.this$1 = var1_1;
                            this.val$projectDescriptors = collection;
                        }

                        protected void execute(IProgressMonitor m) throws CoreException, InvocationTargetException, InterruptedException {
                            m.beginTask("Unzipping Projects", this.val$projectDescriptors.size());
                            Iterator<E> i = this.val$projectDescriptors.iterator();
                            while (i.hasNext()) {
                                AbstractExampleWizard.access$0(1.access$0(this.this$1), (ProjectDescriptor)i.next(), m);
                                m.worked(1);
                            }
                        }
                    };
                    op.run(monitor);
                }

                static /* synthetic */ AbstractExampleWizard access$0(1 var0) {
                    return var0.AbstractExampleWizard.this;
                }
            });
        }
        catch (InvocationTargetException e) {
            this.log(e);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected abstract void log(Exception var1);

    protected abstract Collection getProjectDescriptors();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipProject(ProjectDescriptor descriptor, IProgressMonitor monitor) {
        String bundleName = descriptor.getBundleName();
        String zipLocation = descriptor.getZipLocation();
        String projectName = descriptor.getProjectName();
        URL interpreterZipUrl = FileLocator.find((Bundle)Platform.getBundle((String)bundleName), (IPath)new Path(zipLocation), null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            return;
        }
        try {
            project.create(monitor);
            ZipInputStream zipFileStream = new ZipInputStream(interpreterZipUrl.openStream());
            ZipEntry zipEntry = zipFileStream.getNextEntry();
            String regexedProjectName = projectName.replaceAll("\\.", "\\.");
            while (true) {
                block13: {
                    if (zipEntry == null) {
                        project.open(monitor);
                        project.refreshLocal(2, monitor);
                        project.close(monitor);
                        project.open(monitor);
                        return;
                    }
                    File file = new File(project.getLocation().toString(), zipEntry.getName().replaceFirst("^" + regexedProjectName + "/", ""));
                    if (!zipEntry.isDirectory()) {
                        Object var16_18;
                        File parentFile = file.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            parentFile.mkdirs();
                        }
                        FileOutputStream os = null;
                        try {
                            os = new FileOutputStream(file);
                            byte[] buffer = new byte[102400];
                            while (true) {
                                int len = zipFileStream.read(buffer);
                                if (zipFileStream.available() != 0) {
                                    ((OutputStream)os).write(buffer, 0, len);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            var16_18 = null;
                            if (os == null) throw throwable;
                            ((OutputStream)os).close();
                            throw throwable;
                        }
                        {
                            var16_18 = null;
                            if (os == null) break block13;
                        }
                        ((OutputStream)os).close();
                    }
                }
                zipFileStream.closeEntry();
                zipEntry = zipFileStream.getNextEntry();
            }
        }
        catch (IOException e) {
            this.log(e);
            return;
        }
        catch (CoreException e) {
            this.log((Exception)((Object)e));
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    static /* synthetic */ void access$0(AbstractExampleWizard abstractExampleWizard, ProjectDescriptor projectDescriptor, IProgressMonitor iProgressMonitor) {
        abstractExampleWizard.unzipProject(projectDescriptor, iProgressMonitor);
    }

    public static class ProjectDescriptor {
        private String bundleName;
        private String zipLocation;
        private String projectName;

        public ProjectDescriptor(String bundleName, String zipLocation, String projectName) {
            this.bundleName = bundleName;
            this.zipLocation = zipLocation;
            this.projectName = projectName;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getZipLocation() {
            return this.zipLocation;
        }
    }
}

